/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.element;

import com.infinite_craft.element.ElementComponentType;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class DiscoveringPlayerData {
    public static final class_2960 DISCOVERED_ELEMENT_KEY = class_2960.method_60655((String)"infinite_craft", (String)"discovered_elements");
    public static final Codec<Map<String, ElementComponentType>> ELEMENT_MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ElementComponentType.CODEC);
    public static final Codec<DiscoveringPlayerData> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ElementComponentType.CODEC).xmap(DiscoveringPlayerData::new, DiscoveringPlayerData::getData).orElse((Object)new DiscoveringPlayerData(new HashMap<String, ElementComponentType>()));
    public static final class_9331<Map<String, ElementComponentType>> DISCOVERED_ELEMENTS = class_9331.method_57873().method_57881(ELEMENT_MAP_CODEC).method_57880();
    private Map<String, ElementComponentType> data;

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)DISCOVERED_ELEMENT_KEY, DISCOVERED_ELEMENTS);
    }

    public DiscoveringPlayerData() {
        this.data = new HashMap<String, ElementComponentType>();
    }

    public DiscoveringPlayerData(Map<String, ElementComponentType> discoveredData) {
        this.data = new HashMap<String, ElementComponentType>(discoveredData);
    }

    public boolean add(ElementComponentType newElement) {
        if (this.data.containsKey(newElement.name())) {
            return false;
        }
        this.data.put(newElement.name(), newElement);
        return true;
    }

    public boolean remove(String elementName) {
        if (!this.data.containsKey(elementName)) {
            return false;
        }
        this.data.remove(elementName);
        return true;
    }

    public Optional<ElementComponentType> get(String elementName) {
        if (this.data.containsKey(elementName)) {
            return Optional.of(this.data.get(elementName));
        }
        return Optional.empty();
    }

    public void writeTo(class_11372 view) {
        view.method_71468(DISCOVERED_ELEMENT_KEY.toString(), ELEMENT_MAP_CODEC, this.data);
    }

    public void readFrom(class_11368 view) {
        this.data.clear();
        view.method_71426(DISCOVERED_ELEMENT_KEY.toString(), ELEMENT_MAP_CODEC).ifPresent(newData -> {
            this.data = new HashMap<String, ElementComponentType>((Map<String, ElementComponentType>)newData);
        });
    }

    public class_2487 toNbt() {
        class_2487 result = new class_2487();
        this.data.forEach((key, value) -> result.method_67494(key, ElementComponentType.CODEC, value));
        return result;
    }

    public Map<String, ElementComponentType> getData() {
        return this.data;
    }
}

