/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.element;

import com.infinite_craft.element.DiscoveringPlayerData;
import com.infinite_craft.element.ElementComponentType;
import com.infinite_craft.element.ElementItems;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class ElementData {
    String name;
    String emoji;
    String color;
    class_2960 model;
    Optional<String> translated;

    private void init(String emoji, String name, String color, class_2960 model, Optional<String> translated) throws NullPointerException {
        if (emoji == null || name == null || color == null || model == null || translated == null) {
            throw new NullPointerException("Null string when constructing ElementData");
        }
        this.emoji = emoji;
        this.name = ElementData.toTitleCase(name);
        this.color = color;
        this.model = model;
        translated.ifPresentOrElse(str -> {
            this.translated = Optional.of(ElementData.toTitleCase(str));
        }, () -> {
            this.translated = Optional.empty();
        });
    }

    public ElementData(String emoji, String name, String color, class_2960 model) throws NullPointerException {
        this.init(emoji, name, color, model, Optional.empty());
    }

    public ElementData(String emoji, String name, String color, class_2960 model, String translated) throws NullPointerException {
        this.init(emoji, name, color, model, Optional.ofNullable(translated));
    }

    public ElementData(class_2487 nbtCompound) throws NullPointerException, NoSuchElementException {
        if (!(nbtCompound.method_10558("name").isPresent() && nbtCompound.method_10558("emoji").isPresent() && nbtCompound.method_10558("color").isPresent() && nbtCompound.method_10558("model").isPresent())) {
            throw new NullPointerException("Illegal nbt compound when constructing ElementData");
        }
        this.init((String)nbtCompound.method_10558("name").get(), (String)nbtCompound.method_10558("emoji").get(), (String)nbtCompound.method_10558("color").get(), Optional.ofNullable(class_2960.method_12829((String)((String)nbtCompound.method_10558("model").get()))).orElseThrow(), nbtCompound.method_10558("translated"));
    }

    public ElementData(ElementComponentType componentType) throws NullPointerException {
        this.init(componentType.emoji(), componentType.name(), componentType.color(), componentType.model(), componentType.translated());
    }

    public ElementComponentType generateElementComponent() {
        return new ElementComponentType(this.emoji, this.name, this.color, this.model, this.translated);
    }

    public static boolean isElement(class_1799 itemStack) {
        return itemStack.method_57353().method_57832(ElementItems.ELEMENT_COMPONENT);
    }

    public static Optional<ElementData> fromItem(class_1799 itemStack) {
        if (!ElementData.isElement(itemStack)) {
            return Optional.empty();
        }
        return Optional.of(new ElementData((ElementComponentType)itemStack.method_57353().method_58694(ElementItems.ELEMENT_COMPONENT)));
    }

    public String getName() {
        return this.name;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getColor() {
        return this.color;
    }

    public String toString() {
        return String.format("%s%s", this.emoji, this.name);
    }

    public static String toTitleCase(String input) {
        StringBuilder result = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '_') {
                ElementData.appendWord(result, currentWord);
                continue;
            }
            currentWord.append(c);
        }
        ElementData.appendWord(result, currentWord);
        return result.toString().trim();
    }

    private static void appendWord(StringBuilder result, StringBuilder word) {
        if (word.length() == 0) {
            return;
        }
        String w = word.toString();
        result.append(Character.toUpperCase(w.charAt(0)));
        if (w.length() > 1) {
            result.append(w.substring(1));
        }
        result.append(" ");
        word.setLength(0);
    }

    public ElementData checked(DiscoveringPlayerData checkingData) {
        checkingData.get(this.name).ifPresent(value -> this.init(value.emoji(), value.name(), value.color(), value.model(), value.translated()));
        return this;
    }

    public class_2960 getModel() {
        return this.model;
    }

    public Optional<String> getTranslated() {
        return this.translated;
    }
}

