/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity;

import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.BreakException;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Macro;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Node;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ParseException;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Template;
import java.io.IOException;
import java.util.Map;

class ParseNode
extends Node {
    private final ExpressionNode nestedResourceNameExpression;
    private final Template.ResourceOpener resourceOpener;
    private final Map<String, Template> parseCache;

    ParseNode(String resourceName, int startLine, ExpressionNode nestedResourceNameExpression, Template.ResourceOpener resourceOpener, Map<String, Template> parseCache) {
        super(resourceName, startLine);
        this.nestedResourceNameExpression = nestedResourceNameExpression;
        this.resourceOpener = resourceOpener;
        this.parseCache = parseCache;
    }

    @Override
    void render(EvaluationContext context, StringBuilder output) {
        block6: {
            Object resourceNameObject = this.nestedResourceNameExpression.evaluate(context);
            if (!(resourceNameObject instanceof String)) {
                String what = resourceNameObject == null ? "null" : resourceNameObject.getClass().getName();
                throw this.evaluationException("Argument to #parse must be a string, not " + what);
            }
            String resourceName = (String)resourceNameObject;
            Template template = this.parseCache.get(resourceName);
            if (template == null) {
                try {
                    template = Template.parseFrom(resourceName, this.resourceOpener, this.parseCache);
                    this.parseCache.put(resourceName, template);
                }
                catch (ParseException | IOException e) {
                    throw this.evaluationException(e);
                }
            }
            template.getMacros().forEach((name, macro) -> context.getMacros().putIfAbsent((String)name, (Macro)macro));
            try {
                template.render(context, output);
            }
            catch (BreakException e) {
                if (!e.forEachScope()) break block6;
                throw e;
            }
        }
    }
}

