/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.AnnotationMirrors;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreElements;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.service.AutoService;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableBiMap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableListMultimap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.Iterables;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.infinite_craft.libs.com.google.auto.value.processor.AbortProcessingException;
import com.infinite_craft.libs.com.google.auto.value.processor.AnnotatedTypeMirror;
import com.infinite_craft.libs.com.google.auto.value.processor.AutoOneOfTemplateVars;
import com.infinite_craft.libs.com.google.auto.value.processor.AutoValueishProcessor;
import com.infinite_craft.libs.com.google.auto.value.processor.MissingTypes;
import com.infinite_craft.libs.com.google.auto.value.processor.Nullables;
import com.infinite_craft.libs.com.google.auto.value.processor.Reformatter;
import com.infinite_craft.libs.com.google.auto.value.processor.TypeEncoder;
import com.infinite_craft.libs.com.google.auto.value.processor.TypeSimplifier;
import com.infinite_craft.libs.javax.annotation.processing.Processor;
import com.infinite_craft.libs.javax.annotation.processing.SupportedAnnotationTypes;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.infinite_craft.libs.com.google.auto.value.AutoOneOf"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public class AutoOneOfProcessor
extends AutoValueishProcessor {
    public AutoOneOfProcessor() {
        super("com.infinite_craft.libs.com.google.auto.value.AutoOneOf", false);
    }

    @Override
    boolean propertiesCanBeVoid() {
        return true;
    }

    public ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.of("com.infinite_craft.libs.com.google.auto.value.NullableTypeAnnotation");
    }

    @Override
    void processType(TypeElement autoOneOfType) {
        DeclaredType kindMirror = this.mirrorForKindType(autoOneOfType);
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(autoOneOfType, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        ImmutableSet<ExecutableElement> abstractMethods = AutoOneOfProcessor.abstractMethodsIn(methods);
        ExecutableElement kindGetter = this.findKindGetterOrAbort(autoOneOfType, kindMirror, abstractMethods);
        LinkedHashSet<ExecutableElement> otherMethods = new LinkedHashSet<ExecutableElement>(abstractMethods);
        otherMethods.remove(kindGetter);
        ImmutableMap<ExecutableElement, AnnotatedTypeMirror> propertyMethodsAndTypes = this.propertyMethodsIn(otherMethods, autoOneOfType);
        ImmutableBiMap<String, ExecutableElement> properties = this.propertyNameToMethodMap(propertyMethodsAndTypes.keySet());
        this.validateMethods(autoOneOfType, abstractMethods, (ImmutableSet<ExecutableElement>)propertyMethodsAndTypes.keySet(), kindGetter);
        ImmutableMap<String, String> propertyToKind = this.propertyToKindMap(kindMirror, (ImmutableSet<String>)properties.keySet());
        String subclass = AutoOneOfProcessor.generatedClassName(autoOneOfType, "AutoOneOf_");
        AutoOneOfTemplateVars vars = new AutoOneOfTemplateVars();
        vars.generatedClass = TypeSimplifier.simpleNameOf(subclass);
        vars.propertyToKind = propertyToKind;
        Nullables nullables = Nullables.fromMethods(this.processingEnv, methods);
        this.defineSharedVarsForType(autoOneOfType, methods, nullables, vars);
        this.defineVarsForType(autoOneOfType, vars, propertyMethodsAndTypes, kindGetter, nullables);
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, autoOneOfType.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(subclass, text, autoOneOfType);
    }

    private DeclaredType mirrorForKindType(TypeElement autoOneOfType) {
        AnnotationMirror oneOfAnnotation = AutoOneOfProcessor.getAnnotationMirror(autoOneOfType, "com.infinite_craft.libs.com.google.auto.value.AutoOneOf").get();
        AnnotationValue kindValue = AnnotationMirrors.getAnnotationValue(oneOfAnnotation, "value");
        Object value = kindValue.getValue();
        if (value instanceof TypeMirror) {
            TypeMirror kindType = (TypeMirror)value;
            switch (kindType.getKind()) {
                case DECLARED: {
                    return MoreTypes.asDeclared(kindType);
                }
                case ERROR: {
                    throw new MissingTypes.MissingTypeException(MoreTypes.asError(kindType));
                }
            }
        }
        throw new MissingTypes.MissingTypeException(null);
    }

    private ImmutableMap<String, String> propertyToKindMap(DeclaredType kindMirror, ImmutableSet<String> propertyNames) {
        TypeElement kindElement = MoreElements.asType(kindMirror.asElement());
        Map<String, String> transformedPropertyNames = propertyNames.stream().collect(Collectors.toMap(this::transformName, s2 -> s2));
        Map<String, Element> transformedEnumConstants = kindElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).collect(Collectors.toMap(e -> this.transformName(e.getSimpleName().toString()), e -> e));
        if (transformedPropertyNames.keySet().equals(transformedEnumConstants.keySet())) {
            ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();
            for (String transformed2 : transformedPropertyNames.keySet()) {
                mapBuilder.put(transformedPropertyNames.get(transformed2), transformedEnumConstants.get(transformed2).getSimpleName().toString());
            }
            return mapBuilder.build();
        }
        transformedPropertyNames.forEach((transformed, property) -> {
            if (!transformedEnumConstants.containsKey(transformed)) {
                this.errorReporter().reportError(kindElement, "[AutoOneOfNoEnumConstant] Enum has no constant with name corresponding to property '%s'", property);
            }
        });
        transformedEnumConstants.forEach((transformed, constant) -> {
            if (!transformedPropertyNames.containsKey(transformed)) {
                this.errorReporter().reportError((Element)constant, "[AutoOneOfBadEnumConstant] Name of enum constant '%s' does not correspond to any property name", constant.getSimpleName());
            }
        });
        throw new AbortProcessingException();
    }

    private String transformName(String s2) {
        return s2.toLowerCase(Locale.ROOT).replace("_", "");
    }

    private ExecutableElement findKindGetterOrAbort(TypeElement autoOneOfType, TypeMirror kindMirror, ImmutableSet<ExecutableElement> abstractMethods) {
        Set kindGetters = abstractMethods.stream().filter(e -> AutoOneOfProcessor.sameType(kindMirror, e.getReturnType())).filter(e -> e.getParameters().isEmpty()).collect(Collectors.toSet());
        switch (kindGetters.size()) {
            case 0: {
                this.errorReporter().reportError(autoOneOfType, "[AutoOneOfNoKindGetter] %s must have a no-arg abstract method returning %s", autoOneOfType, kindMirror);
                break;
            }
            case 1: {
                return (ExecutableElement)Iterables.getOnlyElement(kindGetters);
            }
            default: {
                for (ExecutableElement getter : kindGetters) {
                    this.errorReporter().reportError(getter, "[AutoOneOfTwoKindGetters] More than one abstract method returns %s", kindMirror);
                }
            }
        }
        throw new AbortProcessingException();
    }

    private void validateMethods(TypeElement type, ImmutableSet<ExecutableElement> abstractMethods, ImmutableSet<ExecutableElement> propertyMethods, ExecutableElement kindGetter) {
        for (ExecutableElement method : abstractMethods) {
            if (propertyMethods.contains(method)) {
                this.checkReturnType(type, method);
                continue;
            }
            if (method.equals(kindGetter) || AutoOneOfProcessor.objectMethodToOverride(method) != AutoValueishProcessor.ObjectMethod.NONE) continue;
            this.errorReporter().reportWarning(method, "[AutoOneOfParams] Abstract methods in @AutoOneOf classes must have no parameters", new Object[0]);
        }
        this.errorReporter().abortIfAnyError();
    }

    private void defineVarsForType(TypeElement type, AutoOneOfTemplateVars vars, ImmutableMap<ExecutableElement, AnnotatedTypeMirror> propertyMethodsAndTypes, ExecutableElement kindGetter, Nullables nullables) {
        vars.props = this.propertySet(propertyMethodsAndTypes, ImmutableListMultimap.of(), ImmutableListMultimap.of(), nullables);
        vars.kindGetter = kindGetter.getSimpleName().toString();
        vars.kindType = TypeEncoder.encode(kindGetter.getReturnType());
        TypeElement javaIoSerializable = this.elementUtils().getTypeElement("java.io.Serializable");
        vars.serializable = javaIoSerializable != null && this.typeUtils().isAssignable(type.asType(), javaIoSerializable.asType());
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        if (AutoOneOfProcessor.nullableAnnotationFor(propertyMethod, propertyMethod.getReturnType()).isPresent()) {
            this.errorReporter().reportError(propertyMethod, "[AutoOneOfNullable] @AutoOneOf properties cannot be @Nullable", new Object[0]);
        }
        return Optional.empty();
    }

    private static boolean sameType(TypeMirror t1, TypeMirror t2) {
        return MoreTypes.equivalence().equivalent(t1, t2);
    }
}

