/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreStreams;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.com.google.auto.value.processor.AnnotatedTypeMirror;
import java.util.stream.IntStream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.Types;

final class MethodSignature {
    private final ExecutableType originalMethod;
    private final ExecutableType rewrittenMethod;

    private MethodSignature(ExecutableType originalMethod, ExecutableType rewrittenMethod) {
        this.originalMethod = originalMethod;
        this.rewrittenMethod = rewrittenMethod;
    }

    ImmutableList<AnnotatedTypeMirror> parameterTypes() {
        return IntStream.range(0, this.originalMethod.getParameterTypes().size()).mapToObj(i -> new AnnotatedTypeMirror(this.originalMethod.getParameterTypes().get(i), this.rewrittenMethod.getParameterTypes().get(i))).collect(MoreStreams.toImmutableList());
    }

    AnnotatedTypeMirror returnType() {
        return new AnnotatedTypeMirror(this.originalMethod.getReturnType(), this.rewrittenMethod.getReturnType());
    }

    static MethodSignature asMemberOf(Types typeUtils, DeclaredType in, ExecutableElement method) {
        return new MethodSignature(MoreTypes.asExecutable(method.asType()), MoreTypes.asExecutable(typeUtils.asMemberOf(in, method)));
    }

    static MethodSignature asMemberOf(Types typeUtils, TypeElement in, ExecutableElement method) {
        return MethodSignature.asMemberOf(typeUtils, MoreTypes.asDeclared(in.asType()), method);
    }
}

