/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai;

import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.ObjectNode;
import com.infinite_craft.libs.com.google.genai.ApiClient;
import com.infinite_craft.libs.com.google.genai.AsyncPager;
import com.infinite_craft.libs.com.google.genai.BasePager;
import com.infinite_craft.libs.com.google.genai.Caches;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.errors.GenAiIOException;
import com.infinite_craft.libs.com.google.genai.types.CachedContent;
import com.infinite_craft.libs.com.google.genai.types.CreateCachedContentConfig;
import com.infinite_craft.libs.com.google.genai.types.DeleteCachedContentConfig;
import com.infinite_craft.libs.com.google.genai.types.DeleteCachedContentResponse;
import com.infinite_craft.libs.com.google.genai.types.GetCachedContentConfig;
import com.infinite_craft.libs.com.google.genai.types.ListCachedContentsConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncCaches {
    Caches caches;

    public AsyncCaches(ApiClient apiClient) {
        this.caches = new Caches(apiClient);
    }

    public CompletableFuture<CachedContent> create(String model, CreateCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.create(model, config));
    }

    public CompletableFuture<CachedContent> get(String name, GetCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.get(name, config));
    }

    public CompletableFuture<DeleteCachedContentResponse> delete(String name, DeleteCachedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.caches.delete(name, config));
    }

    public CompletableFuture<AsyncPager<CachedContent>> list(ListCachedContentsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListCachedContentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListCachedContentsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.caches.privateList((ListCachedContentsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.CACHED_CONTENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

