/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai;

import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.ObjectNode;
import com.infinite_craft.libs.com.google.genai.ApiClient;
import com.infinite_craft.libs.com.google.genai.AsyncPager;
import com.infinite_craft.libs.com.google.genai.BasePager;
import com.infinite_craft.libs.com.google.genai.Files;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.errors.GenAiIOException;
import com.infinite_craft.libs.com.google.genai.types.DeleteFileConfig;
import com.infinite_craft.libs.com.google.genai.types.DeleteFileResponse;
import com.infinite_craft.libs.com.google.genai.types.DownloadFileConfig;
import com.infinite_craft.libs.com.google.genai.types.File;
import com.infinite_craft.libs.com.google.genai.types.GeneratedVideo;
import com.infinite_craft.libs.com.google.genai.types.GetFileConfig;
import com.infinite_craft.libs.com.google.genai.types.ListFilesConfig;
import com.infinite_craft.libs.com.google.genai.types.UploadFileConfig;
import com.infinite_craft.libs.com.google.genai.types.Video;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncFiles {
    Files files;

    public AsyncFiles(ApiClient apiClient) {
        this.files = new Files(apiClient);
    }

    public CompletableFuture<File> get(String name, GetFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.get(name, config));
    }

    public CompletableFuture<DeleteFileResponse> delete(String name, DeleteFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.delete(name, config));
    }

    public CompletableFuture<File> upload(java.io.File file, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(file, config));
    }

    public CompletableFuture<File> upload(byte[] bytes, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(bytes, config));
    }

    public CompletableFuture<File> upload(InputStream stream, long size, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(stream, size, config));
    }

    public CompletableFuture<File> upload(String filePath, UploadFileConfig config) {
        return CompletableFuture.supplyAsync(() -> this.files.upload(filePath, config));
    }

    public CompletableFuture<Void> download(String fileName, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(fileName, downloadPath, config));
    }

    public CompletableFuture<Void> download(Video video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(GeneratedVideo video, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(video, downloadPath, config));
    }

    public CompletableFuture<Void> download(File file, String downloadPath, DownloadFileConfig config) {
        return CompletableFuture.runAsync(() -> this.files.download(file, downloadPath, config));
    }

    public CompletableFuture<AsyncPager<File>> list(ListFilesConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListFilesConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListFilesConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.files.privateList((ListFilesConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.FILES, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

