/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai;

import com.infinite_craft.libs.com.google.genai.ApiClient;
import com.infinite_craft.libs.com.google.genai.ChatBase;
import com.infinite_craft.libs.com.google.genai.Models;
import com.infinite_craft.libs.com.google.genai.ResponseStream;
import com.infinite_craft.libs.com.google.genai.Transformers;
import com.infinite_craft.libs.com.google.genai.types.Content;
import com.infinite_craft.libs.com.google.genai.types.GenerateContentConfig;
import com.infinite_craft.libs.com.google.genai.types.GenerateContentResponse;
import java.util.ArrayList;
import java.util.List;

public class Chat
extends ChatBase {
    private final ApiClient apiClient;
    private final Models models;
    private final String model;
    private final GenerateContentConfig config;

    Chat(ApiClient apiClient, String model, GenerateContentConfig config) {
        super(new ArrayList<Content>(), new ArrayList<Content>());
        this.apiClient = apiClient;
        this.models = new Models(apiClient);
        this.model = model;
        this.config = config;
    }

    public GenerateContentResponse sendMessage(String text, GenerateContentConfig config) {
        return this.privateSendMessage(Transformers.tContents(text), config);
    }

    public GenerateContentResponse sendMessage(String text) {
        return this.privateSendMessage(Transformers.tContents(text), null);
    }

    public GenerateContentResponse sendMessage(Content content, GenerateContentConfig config) {
        return this.privateSendMessage(Transformers.tContents(content), config);
    }

    public GenerateContentResponse sendMessage(Content content) {
        return this.privateSendMessage(Transformers.tContents(content), null);
    }

    public GenerateContentResponse sendMessage(List<Content> contents, GenerateContentConfig config) {
        return this.privateSendMessage(contents, config);
    }

    public GenerateContentResponse sendMessage(List<Content> contents) {
        return this.privateSendMessage(contents, null);
    }

    private GenerateContentResponse privateSendMessage(List<Content> contents, GenerateContentConfig config) {
        List<Content> requestContents = this.prepareSendMessageRequest(contents);
        if (this.config != null && config == null) {
            config = this.config;
        }
        GenerateContentResponse response = this.models.generateContent(this.model, requestContents, config);
        this.updateHistoryNonStreaming(response, contents);
        return response;
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text, GenerateContentConfig config) {
        return this.privateSendMessageStream(Transformers.tContents(text), config);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text) {
        return this.privateSendMessageStream(Transformers.tContents(text), null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content, GenerateContentConfig config) {
        return this.privateSendMessageStream(Transformers.tContents(content), config);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content) {
        return this.privateSendMessageStream(Transformers.tContents(content), null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(List<Content> contents, GenerateContentConfig config) {
        return this.privateSendMessageStream(contents, config);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(List<Content> contents) {
        return this.privateSendMessageStream(contents, null);
    }

    private ResponseStream<GenerateContentResponse> privateSendMessageStream(List<Content> contents, GenerateContentConfig config) {
        List<Content> requestContents = this.prepareSendMessageRequest(contents);
        if (this.config != null && config == null) {
            config = this.config;
        }
        ResponseStream<GenerateContentResponse> responseStream = this.models.generateContentStream(this.model, requestContents, config);
        responseStream.recordingHistory = true;
        responseStream.chatSession = this;
        this.currentUserMessage = contents;
        this.currentResponseStream = responseStream;
        return responseStream;
    }
}

