/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai.types;

import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonProperty;
import com.infinite_craft.libs.com.google.genai.types.GroundingSupport;
import com.infinite_craft.libs.com.google.genai.types.Segment;
import java.util.List;
import java.util.Optional;

final class AutoValue_GroundingSupport
extends GroundingSupport {
    private final Optional<List<Float>> confidenceScores;
    private final Optional<List<Integer>> groundingChunkIndices;
    private final Optional<Segment> segment;

    private AutoValue_GroundingSupport(Optional<List<Float>> confidenceScores, Optional<List<Integer>> groundingChunkIndices, Optional<Segment> segment) {
        this.confidenceScores = confidenceScores;
        this.groundingChunkIndices = groundingChunkIndices;
        this.segment = segment;
    }

    @Override
    @JsonProperty(value="confidenceScores")
    public Optional<List<Float>> confidenceScores() {
        return this.confidenceScores;
    }

    @Override
    @JsonProperty(value="groundingChunkIndices")
    public Optional<List<Integer>> groundingChunkIndices() {
        return this.groundingChunkIndices;
    }

    @Override
    @JsonProperty(value="segment")
    public Optional<Segment> segment() {
        return this.segment;
    }

    public String toString() {
        return "GroundingSupport{confidenceScores=" + this.confidenceScores + ", groundingChunkIndices=" + this.groundingChunkIndices + ", segment=" + this.segment + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroundingSupport) {
            GroundingSupport that = (GroundingSupport)o;
            return this.confidenceScores.equals(that.confidenceScores()) && this.groundingChunkIndices.equals(that.groundingChunkIndices()) && this.segment.equals(that.segment());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.confidenceScores.hashCode();
        h$ *= 1000003;
        h$ ^= this.groundingChunkIndices.hashCode();
        h$ *= 1000003;
        return h$ ^= this.segment.hashCode();
    }

    @Override
    public GroundingSupport.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GroundingSupport.Builder {
        private Optional<List<Float>> confidenceScores = Optional.empty();
        private Optional<List<Integer>> groundingChunkIndices = Optional.empty();
        private Optional<Segment> segment = Optional.empty();

        Builder() {
        }

        Builder(GroundingSupport source) {
            this.confidenceScores = source.confidenceScores();
            this.groundingChunkIndices = source.groundingChunkIndices();
            this.segment = source.segment();
        }

        @Override
        public GroundingSupport.Builder confidenceScores(List<Float> confidenceScores) {
            this.confidenceScores = Optional.of(confidenceScores);
            return this;
        }

        @Override
        public GroundingSupport.Builder groundingChunkIndices(List<Integer> groundingChunkIndices) {
            this.groundingChunkIndices = Optional.of(groundingChunkIndices);
            return this;
        }

        @Override
        public GroundingSupport.Builder segment(Segment segment) {
            this.segment = Optional.of(segment);
            return this;
        }

        @Override
        public GroundingSupport build() {
            return new AutoValue_GroundingSupport(this.confidenceScores, this.groundingChunkIndices, this.segment);
        }
    }
}

