/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai.types;

import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonCreator;
import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonProperty;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.infinite_craft.libs.com.google.auto.value.AutoValue;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.types.AutoValue_Content;
import com.infinite_craft.libs.com.google.genai.types.Part;
import com.infinite_craft.libs.org.jspecify.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Content
extends JsonSerializable {
    private static final Logger logger = Logger.getLogger(Content.class.getName());

    @JsonProperty(value="parts")
    public abstract Optional<List<Part>> parts();

    @JsonProperty(value="role")
    public abstract Optional<String> role();

    public static Builder builder() {
        return new AutoValue_Content.Builder();
    }

    public abstract Builder toBuilder();

    public static Content fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Content.class);
    }

    public static Content fromParts(Part ... parts) {
        return Content.builder().role("user").parts(Arrays.asList(parts)).build();
    }

    public @Nullable String text() {
        return Content.aggregateTextFromParts(this.parts().orElse(null));
    }

    static @Nullable String aggregateTextFromParts(List<Part> parts) {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> nonTextParts = new ArrayList<String>();
        for (Part part : parts) {
            if (part.inlineData().isPresent()) {
                nonTextParts.add("inlineData");
            }
            if (part.codeExecutionResult().isPresent()) {
                nonTextParts.add("codeExecutionResult");
            }
            if (part.executableCode().isPresent()) {
                nonTextParts.add("executableCode");
            }
            if (part.fileData().isPresent()) {
                nonTextParts.add("fileData");
            }
            if (part.functionCall().isPresent()) {
                nonTextParts.add("functionCall");
            }
            if (part.functionResponse().isPresent()) {
                nonTextParts.add("functionResponse");
            }
            if (part.videoMetadata().isPresent()) {
                nonTextParts.add("videoMetadata");
            }
            if (part.thought().orElse(false).booleanValue()) continue;
            sb.append(part.text().orElse(""));
        }
        if (!nonTextParts.isEmpty()) {
            logger.warning(String.format("There are non-text parts %s in the content, returning concatenation of all text parts. Please refer to the non text parts for a full response from model.", String.join((CharSequence)", ", nonTextParts)));
        }
        return sb.toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Content.Builder();
        }

        @JsonProperty(value="parts")
        public abstract Builder parts(List<Part> var1);

        @JsonProperty(value="role")
        public abstract Builder role(String var1);

        public abstract Content build();
    }
}

