/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai.types;

import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonCreator;
import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonProperty;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.infinite_craft.libs.com.google.auto.value.AutoValue;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.errors.GenAiIOException;
import com.infinite_craft.libs.com.google.genai.types.AutoValue_Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Image
extends JsonSerializable {
    @JsonProperty(value="gcsUri")
    public abstract Optional<String> gcsUri();

    @JsonProperty(value="imageBytes")
    public abstract Optional<byte[]> imageBytes();

    @JsonProperty(value="mimeType")
    public abstract Optional<String> mimeType();

    public static Builder builder() {
        return new AutoValue_Image.Builder();
    }

    public abstract Builder toBuilder();

    public static Image fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Image.class);
    }

    public static Image fromFile(String location) {
        try {
            String mimeType = Files.probeContentType(Paths.get(location, new String[0]));
            return Image.fromFile(location, mimeType);
        }
        catch (IOException e) {
            return Image.fromFile(location, null);
        }
    }

    public static Image fromFile(String location, String mimeType) {
        try {
            File imagefile = new File(location);
            byte[] imageBytes = Files.readAllBytes(imagefile.toPath());
            Builder builder = Image.builder().imageBytes(imageBytes);
            if (mimeType != null) {
                builder = builder.mimeType(mimeType);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new GenAiIOException(String.format("Failed to read image file: %s", location), e);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Image.Builder();
        }

        @JsonProperty(value="gcsUri")
        public abstract Builder gcsUri(String var1);

        @JsonProperty(value="imageBytes")
        public abstract Builder imageBytes(byte[] var1);

        @JsonProperty(value="mimeType")
        public abstract Builder mimeType(String var1);

        public abstract Image build();
    }
}

