/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.io.opencensus.trace.export;

import com.infinite_craft.libs.io.opencensus.internal.Utils;
import com.infinite_craft.libs.io.opencensus.trace.export.AutoValue_RunningSpanStore_Filter;
import com.infinite_craft.libs.io.opencensus.trace.export.AutoValue_RunningSpanStore_PerSpanNameSummary;
import com.infinite_craft.libs.io.opencensus.trace.export.AutoValue_RunningSpanStore_Summary;
import com.infinite_craft.libs.io.opencensus.trace.export.SpanData;
import com.infinite_craft.libs.javax.annotation.concurrent.Immutable;
import com.infinite_craft.libs.javax.annotation.concurrent.ThreadSafe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@ThreadSafe
public abstract class RunningSpanStore {
    private static final RunningSpanStore NOOP_RUNNING_SPAN_STORE = new NoopRunningSpanStore();

    protected RunningSpanStore() {
    }

    static RunningSpanStore getNoopRunningSpanStore() {
        return NOOP_RUNNING_SPAN_STORE;
    }

    public abstract Summary getSummary();

    public abstract Collection<SpanData> getRunningSpans(Filter var1);

    public abstract void setMaxNumberOfSpans(int var1);

    private static final class NoopRunningSpanStore
    extends RunningSpanStore {
        private static final Summary EMPTY_SUMMARY = Summary.create(Collections.emptyMap());

        private NoopRunningSpanStore() {
        }

        @Override
        public Summary getSummary() {
            return EMPTY_SUMMARY;
        }

        @Override
        public Collection<SpanData> getRunningSpans(Filter filter) {
            Utils.checkNotNull(filter, "filter");
            return Collections.emptyList();
        }

        @Override
        public void setMaxNumberOfSpans(int maxNumberOfSpans) {
            Utils.checkArgument(maxNumberOfSpans >= 0, "Invalid negative maxNumberOfElements");
        }
    }

    @Immutable
    public static abstract class Filter {
        Filter() {
        }

        public static Filter create(String spanName, int maxSpansToReturn) {
            Utils.checkArgument(maxSpansToReturn >= 0, "Negative maxSpansToReturn.");
            return new AutoValue_RunningSpanStore_Filter(spanName, maxSpansToReturn);
        }

        public abstract String getSpanName();

        public abstract int getMaxSpansToReturn();
    }

    @Immutable
    public static abstract class PerSpanNameSummary {
        PerSpanNameSummary() {
        }

        public static PerSpanNameSummary create(int numRunningSpans) {
            Utils.checkArgument(numRunningSpans >= 0, "Negative numRunningSpans.");
            return new AutoValue_RunningSpanStore_PerSpanNameSummary(numRunningSpans);
        }

        public abstract int getNumRunningSpans();
    }

    @Immutable
    public static abstract class Summary {
        Summary() {
        }

        public static Summary create(Map<String, PerSpanNameSummary> perSpanNameSummary) {
            return new AutoValue_RunningSpanStore_Summary(Collections.unmodifiableMap(new HashMap<String, PerSpanNameSummary>(Utils.checkNotNull(perSpanNameSummary, "perSpanNameSummary"))));
        }

        public abstract Map<String, PerSpanNameSummary> getPerSpanNameSummary();
    }
}

