/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack;

import de.vmoon.craftAttack.commands.CraftAttackCommand;
import de.vmoon.craftAttack.commands.StatusCommand;
import de.vmoon.craftAttack.commands.pvpCommand;
import de.vmoon.craftAttack.listeners.ChatListener;
import de.vmoon.craftAttack.listeners.MaintenanceListener;
import de.vmoon.craftAttack.listeners.MotdListener;
import de.vmoon.craftAttack.listeners.PlayerJoinListener;
import de.vmoon.craftAttack.listeners.SpawnBoostListener;
import de.vmoon.craftAttack.listeners.SpawnProtectionListener;
import de.vmoon.craftAttack.listeners.SpawnTeleporterListener;
import de.vmoon.craftAttack.utils.ConfigManager;
import de.vmoon.craftAttack.utils.JsonColorConverter;
import de.vmoon.craftAttack.utils.MaintenanceManager;
import de.vmoon.craftAttack.utils.Metrics;
import de.vmoon.craftAttack.utils.StatusManager;
import de.vmoon.craftAttack.utils.WebServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CraftAttack
extends JavaPlugin {
    private static CraftAttack instance;
    private ConfigManager configManager;
    private pvpCommand pvpCmd;
    private SpawnBoostListener spawnBoostListener;
    private WebServer webServer;
    private SpawnTeleporterListener spawnTeleporterListener;
    private MotdListener motdListener;
    private MaintenanceManager maintenanceManager;
    private MaintenanceListener maintenanceListener;

    public MaintenanceManager getMaintenanceManager() {
        return this.maintenanceManager;
    }

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        int pluginId = 25435;
        new Metrics((Plugin)this, pluginId);
        boolean apiEnabled = this.configManager.isApiEnabled();
        boolean webUiEnabled = this.configManager.isWebServerEnabled();
        if (apiEnabled || webUiEnabled) {
            int port = this.configManager.getServerPort();
            this.webServer = new WebServer(this, port);
            this.webServer.start();
            this.getLogger().info("HTTP-Server l\u00e4uft auf Port " + port);
            if (apiEnabled) {
                this.getLogger().info("JSON-API aktiviert (Endpoint: /api)");
            }
            if (webUiEnabled) {
                this.getLogger().info("Web-Interface aktiviert (Endpoint: /)");
            }
        } else {
            this.getLogger().info("Weder API noch Webserver aktiviert \u2013 HTTP-Server wird nicht gestartet.");
        }
        if (this.getCommand("craftattack") == null) {
            this.getLogger().severe("Der Befehl 'craftattack' wurde nicht in der plugin.yml gefunden!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CraftAttackCommand mainCmd = new CraftAttackCommand();
        this.getCommand("craftattack").setExecutor((CommandExecutor)mainCmd);
        this.getCommand("craftattack").setTabCompleter((TabCompleter)mainCmd);
        StatusManager.init(this, this.configManager);
        StatusCommand statusCommand = new StatusCommand(this);
        this.getCommand("status").setExecutor((CommandExecutor)statusCommand);
        this.getCommand("status").setTabCompleter((TabCompleter)statusCommand);
        this.spawnTeleporterListener = new SpawnTeleporterListener(this, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.spawnTeleporterListener, (Plugin)this);
        this.motdListener = new MotdListener(this.getConfigManager());
        this.getServer().getPluginManager().registerEvents((Listener)this.motdListener, (Plugin)this);
        this.maintenanceManager = new MaintenanceManager(this.configManager);
        this.maintenanceListener = new MaintenanceListener(this.maintenanceManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.maintenanceListener, (Plugin)this);
        SpawnBoostListener listener = SpawnBoostListener.create(this);
        if (listener != null) {
            this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
            this.setSpawnBoostListener(listener);
        } else {
            this.getLogger().info("SpawnElytra-Feature deaktiviert. Kein Listener registriert.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SpawnProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        this.pvpCmd = new pvpCommand();
        if (this.getCommand("pvp") != null) {
            this.getCommand("pvp").setExecutor((CommandExecutor)this.pvpCmd);
            this.getCommand("pvp").setTabCompleter((TabCompleter)this.pvpCmd);
        }
        if (this.configManager.isTabTextEnabled()) {
            this.updateTabText();
        }
        this.getLogger().info("CraftAttack Plugin wurde erfolgreich geladen.");
    }

    public void onDisable() {
        if (this.webServer != null) {
            this.webServer.stop();
            this.getLogger().info("HTTP-Server gestoppt.");
        }
    }

    public static CraftAttack getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public pvpCommand getPvpCmd() {
        return this.pvpCmd;
    }

    public SpawnBoostListener getSpawnBoostListener() {
        return this.spawnBoostListener;
    }

    public void setSpawnBoostListener(SpawnBoostListener listener) {
        this.spawnBoostListener = listener;
    }

    public void updateTabText() {
        String tabJson = this.configManager.getConfig().getString("tab", "{\"text\":\"Default Tab\",\"color\":\"gold\"}");
        String tabText = JsonColorConverter.convertTab(tabJson);
        Bukkit.getOnlinePlayers().forEach(p -> p.setPlayerListHeaderFooter("", tabText));
        this.getLogger().info("Tab-Text wurde aktualisiert.");
    }

    public void restartServer() {
        this.getLogger().info("Starte Server-Neustart...");
        Bukkit.getScheduler().runTask((Plugin)this, Bukkit::shutdown);
    }

    public SpawnTeleporterListener getSpawnTeleporterListener() {
        return this.spawnTeleporterListener;
    }

    public void setSpawnTeleporterListener(SpawnTeleporterListener listener) {
        this.spawnTeleporterListener = listener;
    }

    public MotdListener getMotdListener() {
        return this.motdListener;
    }

    public void setMotdListener(MotdListener listener) {
        this.motdListener = listener;
    }
}

