/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import de.vmoon.craftAttack.CraftAttack;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class AddStatusCommand
implements CommandExecutor {
    private final CraftAttack plugin;

    public AddStatusCommand(CraftAttack plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ca.admin.addstatus")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung, diesen Befehl zu verwenden.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Verwendung: /ca addstatus <statusname> <json>");
            return true;
        }
        String statusName = args[0].toLowerCase();
        StringBuilder jsonBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            jsonBuilder.append(args[i]).append(" ");
        }
        String jsonString = jsonBuilder.toString().trim();
        if (!jsonString.startsWith("{") || !jsonString.endsWith("}")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiges JSON-Format.");
            return true;
        }
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection statusesSection = config.getConfigurationSection("statuses");
        if (statusesSection == null) {
            statusesSection = config.createSection("statuses");
        }
        if (statusesSection.contains(statusName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Ein Status mit diesem Namen existiert bereits.");
            return true;
        }
        statusesSection.set(statusName, (Object)jsonString);
        this.plugin.saveConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Neuer Status '" + statusName + "' wurde hinzugef\u00fcgt.");
        return true;
    }
}

