/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import de.vmoon.craftAttack.CraftAttack;
import de.vmoon.craftAttack.commands.AddStatusCommand;
import de.vmoon.craftAttack.commands.InvseeCommand;
import de.vmoon.craftAttack.commands.MaintenanceCommand;
import de.vmoon.craftAttack.commands.PregenCommand;
import de.vmoon.craftAttack.commands.ReloadCommand;
import de.vmoon.craftAttack.commands.SetSpawnCommand;
import de.vmoon.craftAttack.commands.SetTextsCommand;
import de.vmoon.craftAttack.commands.StartCommand;
import de.vmoon.craftAttack.commands.TempBanCommand;
import de.vmoon.craftAttack.utils.MaintenanceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CraftAttackCommand
implements CommandExecutor,
TabCompleter {
    private TempBanCommand tempBanCommand = new TempBanCommand();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /craftattack <start|stop|teleportall|settitle|settab|reload|invsee|pvp>");
            return true;
        }
        String sub = args[0].toLowerCase();
        if (sub.equals("pvp")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /craftattack pvp <on|off>");
                return true;
            }
            if (!sender.hasPermission("ca.admin.pvp")) {
                sender.sendMessage("\u00a7cDu hast keine Berechtigung diesen Befehl zu verwenden.");
                return true;
            }
            String pvpAction = args[1].toLowerCase();
            if (pvpAction.equals("on")) {
                CraftAttack.getInstance().getPvpCmd().enablepvp();
                sender.sendMessage("\u00a7aPvP wurde aktiviert.");
                return true;
            }
            if (pvpAction.equals("off")) {
                CraftAttack.getInstance().getPvpCmd().disablepvp();
                sender.sendMessage("\u00a7aPvP wurde deaktiviert.");
                return true;
            }
            sender.sendMessage("\u00a7cUng\u00fcltige Option. Usage: /craftattack pvp <on|off>");
            return true;
        }
        if (sub.equals("start") || sub.equals("stop") || sub.equals("teleportall")) {
            return StartCommand.handle(sender, args);
        }
        if (sub.equals("settitle") || sub.equals("settab")) {
            return SetTextsCommand.handle(sender, args);
        }
        if (sub.equals("reload")) {
            return ReloadCommand.handle(sender, args);
        }
        if (sub.equals("addstatus")) {
            String[] addstatusArgs = new String[args.length - 1];
            System.arraycopy(args, 1, addstatusArgs, 0, addstatusArgs.length);
            return new AddStatusCommand(CraftAttack.getInstance()).onCommand(sender, command, label, addstatusArgs);
        }
        if (sub.equals("setspawn")) {
            return new SetSpawnCommand().onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        if (sub.equals("tempban")) {
            return new TempBanCommand().onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        if (sub.equals("pregen")) {
            return new PregenCommand(CraftAttack.getInstance()).onCommand(sender, command, label, args);
        }
        if (sub.equals("maintenance")) {
            return MaintenanceCommand.handle(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        if (sub.equals("invsee")) {
            if (!CraftAttack.getInstance().getConfigManager().getConfig().getBoolean("invsee", false)) {
                sender.sendMessage("\u00a7cDer invsee-Befehl ist derzeit deaktiviert.");
                return true;
            }
            if (!sender.hasPermission("ca.admin.invsee")) {
                sender.sendMessage("\u00a7cDu hast keine Berechtigung diesen Befehl zu verwenden.");
                return true;
            }
            return InvseeCommand.handle(sender, args);
        }
        sender.sendMessage("\u00a7cUng\u00fcltiger Sub-Befehl. Usage: /craftattack <start|stop|teleportall|settitle|settab|reload|invsee|pvp>");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            if (sender.hasPermission("ca.admin.start")) {
                subs.add("start");
            }
            if (sender.hasPermission("ca.admin.stop")) {
                subs.add("stop");
            }
            if (sender.hasPermission("ca.admin.teleportall")) {
                subs.add("teleportall");
            }
            if (sender.hasPermission("ca.admin.settitle")) {
                subs.add("settitle");
            }
            if (sender.hasPermission("ca.admin.tempban")) {
                subs.add("tempban");
            }
            if (sender.hasPermission("ca.admin.setspawn")) {
                subs.add("setspawn");
            }
            if (sender.hasPermission("ca.admin.addstatus")) {
                subs.add("addstatus");
            }
            if (CraftAttack.getInstance().getConfigManager().isTabTextEnabled() && sender.hasPermission("ca.admin.settab")) {
                subs.add("settab");
            }
            if (sender.hasPermission("ca.admin.reload")) {
                subs.add("reload");
            }
            if (CraftAttack.getInstance().getConfigManager().getConfig().getBoolean("invsee", false) && sender.hasPermission("ca.admin.invsee")) {
                subs.add("invsee");
            }
            if (sender.hasPermission("ca.admin.pvp")) {
                subs.add("pvp");
            }
            if (sender.hasPermission("ca.admin.pregen")) {
                subs.add("pregen");
            }
            if (sender.hasPermission("ca.admin.maintenance")) {
                subs.add("maintenance");
            }
            return subs.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("pvp")) {
                List<String> options = Arrays.asList("on", "off");
                return options.stream().filter(option -> option.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("invsee")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("maintenance") && sender.hasPermission("ca.admin.maintenance")) {
                List<String> options = Arrays.asList("on", "off", "addplayer", "removeplayer");
                return options.stream().filter(option -> option.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("maintenance") && sender.hasPermission("ca.admin.maintenance")) {
            MaintenanceManager manager = CraftAttack.getInstance().getMaintenanceManager();
            if (args[1].equalsIgnoreCase("addplayer")) {
                Set allowedNames = manager.getAllowedPlayers().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).collect(Collectors.toSet());
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !allowedNames.contains(name)).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args[1].equalsIgnoreCase("removeplayer")) {
                return manager.getAllowedPlayers().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).filter(name -> name != null && name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args[1].equalsIgnoreCase("on")) {
                List<String> options = Arrays.asList("force");
                return options.stream().filter(option -> option.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("tempban")) {
            return this.tempBanCommand.onTabComplete(sender, command, alias, Arrays.copyOfRange(args, 1, args.length));
        }
        return new ArrayList<String>();
    }
}

