/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PregenCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;

    public PregenCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        int centerZ;
        int centerX;
        World world;
        int blockRange;
        if (!sender.hasPermission("ca.admin.pregen")) {
            sender.sendMessage("\u00a7cDu hast keine Berechtigung diesen Befehl zu verwenden.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /craftattack pregen [blockweite] [confirm]");
            return true;
        }
        try {
            blockRange = Integer.parseInt(args[1]);
            if (blockRange <= 0) {
                sender.sendMessage("\u00a7cDie Blockweite muss eine positive Zahl sein.");
                return true;
            }
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("\u00a7cDie Blockweite muss eine g\u00fcltige Zahl sein.");
            return true;
        }
        int chunkRadius = (int)Math.ceil((double)blockRange / 16.0);
        final int totalChunks = (2 * chunkRadius + 1) * (2 * chunkRadius + 1);
        if (sender instanceof Player && args.length < 3) {
            sender.sendMessage("\u00a7eWarnung: Du wirst insgesamt " + totalChunks + " Chunks (f\u00fcr " + blockRange + " Bl\u00f6cke) generieren, was den Server stark belasten kann.");
            sender.sendMessage("\u00a7eBitte best\u00e4tige mit: /craftattack pregen " + blockRange + " confirm");
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            world = player.getWorld();
            centerX = player.getLocation().getBlockX();
            centerZ = player.getLocation().getBlockZ();
        } else {
            world = (World)Bukkit.getWorlds().get(0);
            centerX = 0;
            centerZ = 0;
        }
        sender.sendMessage("\u00a7aChunk-Pregen gestartet: Generiere " + totalChunks + " Chunks (Blockweite: " + blockRange + ").");
        int centerChunkX = centerX >> 4;
        int centerChunkZ = centerZ >> 4;
        final ArrayDeque<int[]> chunkQueue = new ArrayDeque<int[]>();
        for (int x = centerChunkX - chunkRadius; x <= centerChunkX + chunkRadius; ++x) {
            int z = centerChunkZ - chunkRadius;
            while (z <= centerChunkZ + chunkRadius) {
                chunkQueue.add(new int[]{x, z++});
            }
        }
        new BukkitRunnable(this){
            final int chunksPerTick = 10;
            int loadedChunks = 0;

            public void run() {
                for (int counter = 0; counter < 10 && !chunkQueue.isEmpty(); ++counter) {
                    int chunkZ;
                    int[] coord = (int[])chunkQueue.poll();
                    int chunkX = coord[0];
                    Chunk chunk = world.getChunkAt(chunkX, chunkZ = coord[1]);
                    if (!chunk.isLoaded()) {
                        chunk.load(true);
                    }
                    ++this.loadedChunks;
                }
                if (sender instanceof Player && this.loadedChunks % 1000 == 0 && this.loadedChunks < totalChunks) {
                    sender.sendMessage("\u00a7aFortschritt: " + this.loadedChunks + " von " + totalChunks + " Chunks geladen.");
                }
                if (chunkQueue.isEmpty()) {
                    if (sender instanceof Player) {
                        sender.sendMessage("\u00a7aChunk-Pregen abgeschlossen. Gesamt: " + this.loadedChunks + " von " + totalChunks + " Chunks geladen.");
                    } else {
                        sender.sendMessage("\u00a7aChunk-Pregen abgeschlossen.");
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("ca.admin.pregen")) {
            return new ArrayList<String>();
        }
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("256");
            suggestions.add("512");
            suggestions.add("1024");
            return suggestions.stream().filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args.length == 3) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("confirm");
            return suggestions.stream().filter(s -> s.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

