/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import de.vmoon.craftAttack.CraftAttack;
import de.vmoon.craftAttack.listeners.MotdListener;
import de.vmoon.craftAttack.listeners.SpawnBoostListener;
import de.vmoon.craftAttack.listeners.SpawnTeleporterListener;
import de.vmoon.craftAttack.utils.StatusManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ReloadCommand {
    public static boolean handle(CommandSender sender, String[] args) {
        SpawnBoostListener newListener;
        if (!sender.hasPermission("ca.admin.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung, die Config neu zu laden!");
            return true;
        }
        CraftAttack plugin = CraftAttack.getInstance();
        plugin.reloadConfig();
        plugin.getConfigManager().reloadExtraConfig();
        if (plugin.getSpawnTeleporterListener() != null) {
            HandlerList.unregisterAll((Listener)plugin.getSpawnTeleporterListener());
        }
        SpawnTeleporterListener newSpawnTeleportListener = new SpawnTeleporterListener(plugin, plugin.getConfigManager());
        plugin.getServer().getPluginManager().registerEvents((Listener)newSpawnTeleportListener, (Plugin)plugin);
        plugin.setSpawnTeleporterListener(newSpawnTeleportListener);
        Bukkit.getOnlinePlayers().forEach(player -> StatusManager.getInstance().updatePlayerOnJoin((Player)player));
        if (plugin.getConfigManager().isTabTextEnabled()) {
            plugin.updateTabText();
        } else {
            Bukkit.getOnlinePlayers().forEach(p -> p.setPlayerListHeaderFooter("", ""));
            plugin.getLogger().info("Tab-Text ist deaktiviert \u2013 daher wurde der Tabtext gel\u00f6scht.");
        }
        if (plugin.getMotdListener() != null) {
            HandlerList.unregisterAll((Listener)plugin.getMotdListener());
        }
        MotdListener newMotdListener = new MotdListener(plugin.getConfigManager());
        plugin.getServer().getPluginManager().registerEvents((Listener)newMotdListener, (Plugin)plugin);
        plugin.setMotdListener(newMotdListener);
        newMotdListener.reloadMotds();
        if (plugin.getSpawnBoostListener() != null) {
            HandlerList.unregisterAll((Listener)plugin.getSpawnBoostListener());
            plugin.getSpawnBoostListener().cancel();
            plugin.setSpawnBoostListener(null);
        }
        if ((newListener = SpawnBoostListener.create(plugin)) != null) {
            plugin.getServer().getPluginManager().registerEvents((Listener)newListener, (Plugin)plugin);
            plugin.setSpawnBoostListener(newListener);
        } else {
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                }
            });
            plugin.getLogger().info("SpawnElytra Feature bleibt deaktiviert. Flight wurde bei allen Spielern deaktiviert.");
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config wurde erfolgreich neu geladen!");
        return true;
    }
}

