/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.vmoon.craftAttack.CraftAttack;
import de.vmoon.craftAttack.utils.JsonColorConverter;
import java.util.Arrays;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetTextsCommand {
    public static boolean handle(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /craftattack <settitle|settab> <JSON>");
            return true;
        }
        String sub = args[0].toLowerCase();
        String newJson = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)).trim();
        if (sub.equals("settitle")) {
            String color;
            JsonObject json;
            if (!sender.hasPermission("ca.admin.settitle")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung, den Title zu setzen!");
                return true;
            }
            String newJson_1 = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            try {
                json = JsonParser.parseString((String)newJson_1).getAsJsonObject();
            }
            catch (JsonSyntaxException | IllegalStateException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiges JSON! Bitte gib ein korrektes JSON-Format an.");
                return true;
            }
            if (!json.has("text") || json.get("text").getAsString().trim().isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Das Feld \"text\" muss vorhanden und nicht leer sein.");
                return true;
            }
            Set<String> validColors = Set.of("dark_red", "red", "gold", "yellow", "dark_green", "green", "aqua", "dark_aqua", "dark_blue", "blue", "light_purple", "dark_purple", "white", "gray", "dark_gray", "black", "reset", "bold", "italic", "underlined", "strikethrough", "obfuscated");
            if (json.has("color") && !validColors.contains(color = json.get("color").getAsString().toLowerCase())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltige Farbe \"" + color + "\". Erlaubt sind z.B. \"red\", \"gold\", \"dark_blue\" usw.");
                return true;
            }
            CraftAttack plugin = CraftAttack.getInstance();
            plugin.getConfig().set("title", (Object)newJson_1);
            plugin.saveConfig();
            String title = JsonColorConverter.convertTitle(newJson_1);
            for (Player p2 : Bukkit.getOnlinePlayers()) {
                p2.sendTitle(title, "", 10, 40, 10);
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Title erfolgreich aktualisiert!");
            return true;
        }
        if (sub.equals("settab")) {
            String color;
            JsonObject json;
            if (!CraftAttack.getInstance().getConfigManager().isTabTextEnabled()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Die Tabtext-Funktion ist in der Config deaktiviert.");
                return true;
            }
            if (!sender.hasPermission("ca.admin.settab")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung, den Tab-Text zu setzen!");
                return true;
            }
            Set<String> validColors = Set.of("dark_red", "red", "gold", "yellow", "dark_green", "green", "aqua", "dark_aqua", "dark_blue", "blue", "light_purple", "dark_purple", "white", "gray", "dark_gray", "black", "reset", "bold", "italic", "underlined", "strikethrough", "obfuscated");
            try {
                json = JsonParser.parseString((String)newJson).getAsJsonObject();
            }
            catch (JsonSyntaxException | IllegalStateException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiges JSON! Bitte gib ein korrektes JSON-Format an.");
                return true;
            }
            if (!json.has("text") || json.get("text").getAsString().trim().isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Das Feld \"text\" muss vorhanden und nicht leer sein.");
                return true;
            }
            if (json.has("color") && !validColors.contains(color = json.get("color").getAsString().toLowerCase())) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltige Farbe \"" + color + "\". Erlaubt sind z.B. \"red\", \"gold\", \"dark_blue\" usw.");
                return true;
            }
            CraftAttack.getInstance().getConfig().set("tab", (Object)newJson);
            CraftAttack.getInstance().saveConfig();
            String tabText = JsonColorConverter.convertTab(newJson);
            Bukkit.getOnlinePlayers().forEach(p -> p.setPlayerListHeaderFooter("", tabText));
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Tab-Text erfolgreich aktualisiert!");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiger Sub-Befehl. Usage: settitle|settab");
        return true;
    }
}

