/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

public class TempBanCommand
implements CommandExecutor,
TabCompleter {
    private final Pattern timePattern = Pattern.compile("(\\d+)([smhd])");
    private final List<String> reasonSuggestions = Arrays.asList("Spam", "Beleidigung", "Griefing", "Cheating", "Werbung", "Sonstiges");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player onlinePlayer;
        if (!sender.hasPermission("ca.admin.tempban")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung f\u00fcr diesen Befehl (ca.admin.tempban).");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Verwendung: /craftattack tempban <Spieler> <Zeit> [Grund]");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Beispiel: /craftattack tempban Steve 2d Beleidigung");
            return true;
        }
        String targetName = args[0];
        String timeString = args[1];
        String reason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "Tempor\u00e4rer Ban";
        long duration = this.parseTime(timeString);
        if (duration <= 0L) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltige Zeitangabe! Beispiele: 30m, 15m, 2h, 3d, 24h=1d");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || target.getName() == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Spieler '" + targetName + "' wurde nicht gefunden.");
            return true;
        }
        String bannedName = target.getName();
        Date expireDate = new Date(System.currentTimeMillis() + duration);
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(bannedName, reason, expireDate, sender.getName());
        if (target.isOnline() && (onlinePlayer = target.getPlayer()) != null) {
            onlinePlayer.kickPlayer(String.valueOf(ChatColor.RED) + "Du wurdest tempor\u00e4r gebannt!\n" + String.valueOf(ChatColor.YELLOW) + "Grund: " + reason + "\n" + String.valueOf(ChatColor.YELLOW) + "Dauer: " + this.formatDuration(duration) + "\n" + String.valueOf(ChatColor.YELLOW) + "Ablauf: " + String.valueOf(expireDate));
        }
        Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(op -> op.sendMessage(String.valueOf(ChatColor.GOLD) + "[CraftAttack] " + String.valueOf(ChatColor.RED) + bannedName + " wurde f\u00fcr " + this.formatDuration(duration) + " gebannt. Grund: " + reason));
        return true;
    }

    private long parseTime(String input) {
        input = input.toLowerCase().replace("24h", "1d");
        Matcher matcher = this.timePattern.matcher(input);
        long total = 0L;
        block12: while (matcher.find()) {
            int amount = Integer.parseInt(matcher.group(1));
            switch (matcher.group(2)) {
                case "s": {
                    total += TimeUnit.SECONDS.toMillis(amount);
                    continue block12;
                }
                case "m": {
                    total += TimeUnit.MINUTES.toMillis(amount);
                    continue block12;
                }
                case "h": {
                    total += TimeUnit.HOURS.toMillis(amount);
                    continue block12;
                }
                case "d": {
                    total += TimeUnit.DAYS.toMillis(amount);
                    continue block12;
                }
            }
            return -1L;
        }
        return total;
    }

    private String formatDuration(long millis) {
        long d = TimeUnit.MILLISECONDS.toDays(millis);
        long h = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long m = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        StringBuilder sb = new StringBuilder();
        if (d > 0L) {
            sb.append(d).append("d ");
        }
        if (h > 0L) {
            sb.append(h).append("h ");
        }
        if (m > 0L) {
            sb.append(m).append("m ");
        }
        return sb.toString().trim();
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("ca.admin.tempban")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).filter(Objects::nonNull).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            List<String> suggestions = Arrays.asList("30m", "1h", "5h", "24h", "1d", "7d");
            String partial = args[1].toLowerCase();
            return suggestions.stream().filter(s -> s.startsWith(partial)).collect(Collectors.toList());
        }
        if (args.length >= 3) {
            String partialReason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)).toLowerCase();
            return this.reasonSuggestions.stream().filter(r -> r.toLowerCase().startsWith(partialReason)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

