/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.listeners;

import de.vmoon.craftAttack.CraftAttack;
import de.vmoon.craftAttack.utils.ConfigManager;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;

public class MotdListener
implements Listener {
    private final ConfigManager configManager;
    private List<String> motds;
    private int interval;
    private int currentIndex = 0;
    private long lastUpdateTime = 0L;

    public MotdListener(ConfigManager configManager) {
        this.configManager = configManager;
        this.reloadMotds();
    }

    public void reloadMotds() {
        this.motds = this.configManager.getConfig().getStringList("motd.messages");
        this.interval = this.configManager.getConfig().getInt("motd.interval", 2);
        this.currentIndex = 0;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @EventHandler
    public void onPing(ServerListPingEvent event) {
        CraftAttack plugin = CraftAttack.getInstance();
        if (plugin.getMaintenanceManager().isActive()) {
            String maintenanceMotd = plugin.getConfigManager().getConfig().getString("motd.maintenance", "\u00a7cWartungsmodus aktiv");
            event.setMotd(maintenanceMotd);
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdateTime >= (long)(this.interval * 1000)) {
            this.currentIndex = (this.currentIndex + 1) % this.motds.size();
            this.lastUpdateTime = now;
        }
        event.setMotd(this.motds.get(this.currentIndex));
    }
}

