/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.listeners;

import de.vmoon.craftAttack.utils.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.KeybindComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final Plugin plugin;
    private final int multiplyValue;
    private final boolean boostEnabled;
    private final World world;
    private final String message;
    private final double minX;
    private final double minY;
    private final double minZ;
    private final double maxX;
    private final double maxY;
    private final double maxZ;
    private final List<Player> flying = new ArrayList<Player>();
    private final List<Player> boosted = new ArrayList<Player>();

    public static SpawnBoostListener create(JavaPlugin plugin) {
        ConfigManager configManager = new ConfigManager(plugin);
        ConfigurationSection elytraSection = configManager.getConfig().getConfigurationSection("SpawnElytra");
        if (elytraSection == null) {
            plugin.getLogger().severe("Der Konfigurationsabschnitt 'SpawnElytra' wurde nicht gefunden!");
            return null;
        }
        if (!elytraSection.getBoolean("enabled", true)) {
            plugin.getLogger().info("Das Feature SpawnElytra ist deaktiviert.");
            return null;
        }
        int multiplyValue = elytraSection.getInt("multiplyValue", 2);
        boolean boostEnabled = elytraSection.getBoolean("boostEnabled", true);
        String worldName = elytraSection.getString("world", "world");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalArgumentException("Ung\u00fcltige Welt: " + worldName);
        }
        String message = elytraSection.getString("message", "Boost ready: Press %key% to boost");
        double x1 = configManager.getConfig().getDouble("spawnArea.x1", 0.0);
        double y1 = configManager.getConfig().getDouble("spawnArea.y1", 0.0);
        double z1 = configManager.getConfig().getDouble("spawnArea.z1", 0.0);
        double x2 = configManager.getConfig().getDouble("spawnArea.x2", 0.0);
        double y2 = configManager.getConfig().getDouble("spawnArea.y2", 0.0);
        double z2 = configManager.getConfig().getDouble("spawnArea.z2", 0.0);
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxZ = Math.max(z1, z2);
        return new SpawnBoostListener((Plugin)plugin, multiplyValue, boostEnabled, world, message, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private SpawnBoostListener(Plugin plugin, int multiplyValue, boolean boostEnabled, World world, String message, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.plugin = plugin;
        this.multiplyValue = multiplyValue;
        this.boostEnabled = boostEnabled;
        this.world = world;
        this.message = message;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.runTaskTimer(plugin, 0L, 3L);
    }

    public void run() {
        this.world.getPlayers().forEach(player -> {
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            player.setAllowFlight(this.isInSpawnArea((Player)player));
            if (this.flying.contains(player) && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                player.setAllowFlight(false);
                player.setGliding(false);
                this.boosted.remove(player);
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.flying.remove(player), 5L);
            }
        });
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!this.isInSpawnArea(player)) {
            return;
        }
        event.setCancelled(true);
        player.setGliding(true);
        this.flying.add(player);
        if (!this.boostEnabled) {
            return;
        }
        String[] messageParts = this.message.split("%key%");
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder(messageParts[0]).append((BaseComponent)new KeybindComponent("key.swapOffhand")).append(messageParts.length > 1 ? messageParts[1] : "").create());
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        if (!this.boostEnabled || !this.flying.contains(event.getPlayer()) || this.boosted.contains(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
        this.boosted.add(event.getPlayer());
        event.getPlayer().setVelocity(event.getPlayer().getLocation().getDirection().multiply(this.multiplyValue));
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    private boolean isInSpawnArea(Player player) {
        if (!player.getWorld().equals((Object)this.world)) {
            return false;
        }
        double x = player.getLocation().getX();
        double y = player.getLocation().getY();
        double z = player.getLocation().getZ();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }
}

