/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.utils;

import de.vmoon.craftAttack.utils.SpawnTeleporterData;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private FileConfiguration extraConfig;
    private File extraFile;
    private FileConfiguration maintenanceConfig;
    private File maintenanceFile;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.createMaintenanceConfig("maintenance.yml");
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            plugin.saveDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStreamReader defaults = new InputStreamReader(plugin.getResource("config.yml"), StandardCharsets.UTF_8);
        if (defaults != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defaults);
            this.config.setDefaults((Configuration)defConfig);
            this.config.options().copyDefaults(true);
            try {
                this.config.save(configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.createExtraConfig("playerstatuses.yml");
    }

    private void createMaintenanceConfig(String fileName) {
        this.maintenanceFile = new File(this.plugin.getDataFolder(), fileName);
        if (!this.maintenanceFile.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        this.maintenanceConfig = YamlConfiguration.loadConfiguration((File)this.maintenanceFile);
        this.plugin.getLogger().info("Maintenance Config geladen: " + (this.maintenanceConfig != null));
    }

    public FileConfiguration getMaintenanceConfig() {
        if (this.maintenanceConfig == null) {
            this.reloadMaintenanceConfig();
        }
        return this.maintenanceConfig;
    }

    public void reloadMaintenanceConfig() {
        if (this.maintenanceFile != null) {
            this.maintenanceConfig = YamlConfiguration.loadConfiguration((File)this.maintenanceFile);
        }
    }

    public void saveMaintenanceConfig() {
        if (this.maintenanceConfig != null && this.maintenanceFile != null) {
            try {
                this.maintenanceConfig.save(this.maintenanceFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public double getInitialBorder() {
        return this.getConfig().getDouble("worldborder.initial", 100.0);
    }

    public double getTargetBorder() {
        return this.getConfig().getDouble("worldborder.target", 20000.0);
    }

    public double getWorldBorderCenterX() {
        return this.getConfig().getDouble("worldborder.center.x", 0.0);
    }

    public double getWorldBorderCenterZ() {
        return this.getConfig().getDouble("worldborder.center.z", 0.0);
    }

    public double getTeleportX() {
        return this.getConfig().getDouble("teleport.x", 100.0);
    }

    public double getTeleportY() {
        return this.getConfig().getDouble("teleport.y", 64.0);
    }

    public double getTeleportZ() {
        return this.getConfig().getDouble("teleport.z", 100.0);
    }

    public String getWelcomeMessage() {
        return this.getConfig().getString("welcome", "&aWillkommen auf CraftAttack! Viel Spa\u00df beim Spiel!");
    }

    public boolean isTabTextEnabled() {
        return this.getConfig().getBoolean("tabtext", true);
    }

    public FileConfiguration getExtraConfig() {
        if (this.extraConfig == null) {
            this.reloadExtraConfig();
        }
        return this.extraConfig;
    }

    public void reloadExtraConfig() {
        if (this.extraFile != null) {
            this.extraConfig = YamlConfiguration.loadConfiguration((File)this.extraFile);
        }
    }

    private void createExtraConfig(String fileName) {
        this.extraFile = new File(this.plugin.getDataFolder(), fileName);
        if (!this.extraFile.exists()) {
            try {
                this.extraFile.getParentFile().mkdirs();
                this.plugin.saveResource(fileName, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.extraConfig = YamlConfiguration.loadConfiguration((File)this.extraFile);
        this.plugin.getLogger().info("Extra config geladen: " + (this.extraConfig != null));
    }

    public void saveExtraConfig() {
        if (this.extraConfig != null && this.extraFile != null) {
            try {
                this.extraConfig.save(this.extraFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isApiEnabled() {
        return this.getConfig().getBoolean("enable_api", false);
    }

    public boolean isWebServerEnabled() {
        return this.getConfig().getBoolean("enable_webserver", false);
    }

    public int getServerPort() {
        return this.getConfig().getInt("server.port", 8020);
    }

    public SpawnTeleporterData getSpawnTeleporterData() {
        FileConfiguration config = this.getConfig();
        boolean enabled = config.getBoolean("SpawnTeleporter.enabled", true);
        String regionWorld = config.getString("SpawnTeleporter.region.world", "world");
        String sound = config.getString("SpawnTeleporter.sound", "ENTITY_ENDERMAN_TELEPORT");
        int x1 = config.getInt("SpawnTeleporter.region.x1", 0);
        int y1 = config.getInt("SpawnTeleporter.region.y1", 0);
        int z1 = config.getInt("SpawnTeleporter.region.z1", 0);
        int x2 = config.getInt("SpawnTeleporter.region.x2", 0);
        int y2 = config.getInt("SpawnTeleporter.region.y2", 0);
        int z2 = config.getInt("SpawnTeleporter.region.z2", 0);
        int delay = config.getInt("SpawnTeleporter.delay", 5);
        String teleportWorld = config.getString("SpawnTeleporter.teleport.world", "world");
        double teleX = config.getDouble("SpawnTeleporter.teleport.x", 0.0);
        double teleY = config.getDouble("SpawnTeleporter.teleport.y", 64.0);
        double teleZ = config.getDouble("SpawnTeleporter.teleport.z", 0.0);
        return new SpawnTeleporterData(enabled, regionWorld, x1, y1, z1, x2, y2, z2, delay, teleportWorld, teleX, teleY, teleZ, sound);
    }
}

