/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.utils;

import org.bukkit.ChatColor;

public class JsonColorConverter {
    public static String convertJson(String json) {
        return JsonColorConverter.convertText(json);
    }

    public static String convertTitle(String json) {
        return JsonColorConverter.convertText(json);
    }

    public static String convertTab(String json) {
        return JsonColorConverter.convertText(json);
    }

    private static String convertText(String json) {
        if ((json = json.trim()).startsWith("[")) {
            return JsonColorConverter.parseJsonArray(json);
        }
        return JsonColorConverter.convertSingle(json);
    }

    private static String parseJsonArray(String json) {
        String inner = json.substring(1, json.length() - 1).trim();
        StringBuilder result = new StringBuilder();
        int braceDepth = 0;
        boolean inQuotes = false;
        StringBuilder currentElement = new StringBuilder();
        for (int i = 0; i < inner.length(); ++i) {
            char c = inner.charAt(i);
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!inQuotes) {
                if (c == '{') {
                    ++braceDepth;
                }
                if (c == '}') {
                    --braceDepth;
                }
                if (c == ',' && braceDepth == 0) {
                    String element = currentElement.toString().trim();
                    if (!element.isEmpty()) {
                        result.append(JsonColorConverter.parseElement(element));
                    }
                    currentElement.setLength(0);
                    continue;
                }
            }
            currentElement.append(c);
        }
        String element = currentElement.toString().trim();
        if (!element.isEmpty()) {
            result.append(JsonColorConverter.parseElement(element));
        }
        return result.toString();
    }

    private static String parseElement(String element) {
        if ((element = element.trim()).startsWith("{")) {
            return JsonColorConverter.convertSingle(element);
        }
        if (element.startsWith("\"") && element.endsWith("\"")) {
            String literal = element.substring(1, element.length() - 1);
            return literal.replace("\\n", "\n");
        }
        return element;
    }

    public static String convertSingle(String json) {
        String text = JsonColorConverter.extractValue(json, "text");
        if (text == null) {
            text = "";
        }
        text = text.replace("\\n", "\n");
        StringBuilder format = new StringBuilder();
        String color = JsonColorConverter.extractValue(json, "color");
        if (color != null && !color.isEmpty()) {
            try {
                ChatColor chatColor = ChatColor.valueOf((String)color.toUpperCase());
                format.append(chatColor.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("true".equalsIgnoreCase(JsonColorConverter.extractValue(json, "bold"))) {
            format.append(ChatColor.BOLD);
        }
        if ("true".equalsIgnoreCase(JsonColorConverter.extractValue(json, "italic"))) {
            format.append(ChatColor.ITALIC);
        }
        if ("true".equalsIgnoreCase(JsonColorConverter.extractValue(json, "underlined"))) {
            format.append(ChatColor.UNDERLINE);
        }
        if ("true".equalsIgnoreCase(JsonColorConverter.extractValue(json, "strikethrough"))) {
            format.append(ChatColor.STRIKETHROUGH);
        }
        if ("true".equalsIgnoreCase(JsonColorConverter.extractValue(json, "obfuscated"))) {
            format.append(ChatColor.MAGIC);
        }
        return format.toString() + text;
    }

    private static String extractValue(String json, String key) {
        String pattern = "\"" + key + "\":";
        int start = json.indexOf(pattern);
        if (start == -1) {
            return "";
        }
        if (json.charAt(start += pattern.length()) == '\"') {
            int end;
            if ((end = json.indexOf("\"", ++start)) == -1) {
                return "";
            }
            return json.substring(start, end);
        }
        int end = json.indexOf(",", start);
        if (end == -1) {
            end = json.indexOf("}", start);
        }
        if (end == -1) {
            return "";
        }
        return json.substring(start, end).trim();
    }
}

