/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.utils;

import de.vmoon.craftAttack.utils.ConfigManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;

public class MaintenanceManager {
    private final ConfigManager configManager;
    private boolean active;
    private final Set<UUID> allowedPlayers = new HashSet<UUID>();

    public MaintenanceManager(ConfigManager configManager) {
        this.configManager = configManager;
        this.load();
    }

    public void load() {
        FileConfiguration config = this.configManager.getMaintenanceConfig();
        this.active = config.getBoolean("maintenance.active", false);
        this.allowedPlayers.clear();
        for (String uuidStr : config.getStringList("maintenance.whitelist")) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.allowedPlayers.add(uuid);
            }
            catch (Exception exception) {}
        }
    }

    public void save() {
        FileConfiguration config = this.configManager.getMaintenanceConfig();
        config.set("maintenance.active", (Object)this.active);
        config.set("maintenance.whitelist", this.allowedPlayers.stream().map(UUID::toString).collect(Collectors.toList()));
        this.configManager.saveMaintenanceConfig();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.save();
    }

    public boolean isPlayerAllowed(OfflinePlayer player) {
        return this.allowedPlayers.contains(player.getUniqueId());
    }

    public void addPlayer(OfflinePlayer player) {
        this.allowedPlayers.add(player.getUniqueId());
        this.save();
    }

    public void removePlayer(OfflinePlayer player) {
        this.allowedPlayers.remove(player.getUniqueId());
        this.save();
    }

    public Set<UUID> getAllowedPlayers() {
        return new HashSet<UUID>(this.allowedPlayers);
    }
}

