/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.utils;

import de.vmoon.craftAttack.utils.ConfigManager;
import de.vmoon.craftAttack.utils.JsonColorConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class StatusManager {
    private static StatusManager instance;
    private static JavaPlugin pluginInstance;
    private ConfigManager configManager;
    private final Map<UUID, String> playerStatusKeys = new HashMap<UUID, String>();
    private final Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();

    private StatusManager() {
    }

    public static StatusManager getInstance() {
        if (instance == null) {
            instance = new StatusManager();
        }
        return instance;
    }

    public static void init(JavaPlugin plugin, ConfigManager configManager) {
        pluginInstance = plugin;
        StatusManager.getInstance().configManager = configManager;
    }

    public Map<String, String> getStatusPermissions() {
        HashMap<String, String> permissions = new HashMap<String, String>();
        if (pluginInstance == null) {
            return permissions;
        }
        ConfigurationSection statusesSection = pluginInstance.getConfig().getConfigurationSection("statuses");
        if (statusesSection == null) {
            return permissions;
        }
        for (String statusKey : statusesSection.getKeys(false)) {
            permissions.put(statusKey, "ca.status." + statusKey.toLowerCase());
        }
        return permissions;
    }

    public void setPlayerStatus(Player player, String statusKey) {
        this.playerStatusKeys.put(player.getUniqueId(), statusKey);
        this.configManager.getExtraConfig().set(player.getUniqueId().toString(), (Object)statusKey);
        this.configManager.saveExtraConfig();
        String formattedPrefix = this.getFormattedStatus(statusKey);
        this.updatePlayerTeam(player, formattedPrefix);
    }

    public String getPlayerStatus(Player player) {
        String statusKey = this.playerStatusKeys.getOrDefault(player.getUniqueId(), "");
        return this.getFormattedStatus(statusKey);
    }

    private String getFormattedStatus(String statusKey) {
        if (statusKey == null || statusKey.isEmpty() || pluginInstance == null) {
            return "";
        }
        String statusJson = pluginInstance.getConfig().getConfigurationSection("statuses").getString(statusKey, "");
        if (statusJson.isEmpty()) {
            return "";
        }
        return JsonColorConverter.convertJson(statusJson);
    }

    private void updatePlayerTeam(Player player, String prefix) {
        String teamName = "status_" + player.getUniqueId().toString().substring(0, 8);
        Team team = this.scoreboard.getTeam(teamName);
        if (team == null) {
            team = this.scoreboard.registerNewTeam(teamName);
        }
        team.setPrefix(prefix + " ");
        team.addEntry(player.getName());
    }

    public void updatePlayerOnJoin(Player player) {
        String storedStatus = this.configManager.getExtraConfig().getString(player.getUniqueId().toString(), "");
        this.playerStatusKeys.put(player.getUniqueId(), storedStatus);
        this.updatePlayerTeam(player, this.getFormattedStatus(storedStatus));
    }

    public void removePlayer(Player player) {
        this.playerStatusKeys.remove(player.getUniqueId());
        this.configManager.getExtraConfig().set(player.getUniqueId().toString(), null);
        this.configManager.saveExtraConfig();
        String teamName = "status_" + player.getUniqueId().toString().substring(0, 8);
        Team team = this.scoreboard.getTeam(teamName);
        if (team != null) {
            team.removeEntry(player.getName());
        }
    }
}

