/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.utils;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.vmoon.craftAttack.CraftAttack;
import de.vmoon.craftAttack.webserver.MaintenanceHandler;
import de.vmoon.craftAttack.webserver.ManagementHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WebServer {
    private final JavaPlugin plugin;
    private final int port;
    private HttpServer server;

    public WebServer(JavaPlugin plugin, int port) {
        this.plugin = plugin;
        this.port = port;
    }

    public void start() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            CraftAttack main = (CraftAttack)this.plugin;
            if (main.getConfigManager().isApiEnabled()) {
                this.server.createContext("/api/whitelist", new ApiHandler());
                this.server.createContext("/api/management", new ManagementHandler((CraftAttack)this.plugin));
                this.server.createContext("/api/maintenance", new MaintenanceHandler((CraftAttack)this.plugin));
            }
            if (main.getConfigManager().isWebServerEnabled()) {
                this.server.createContext("/", new ResourceHandler(this.plugin));
            }
            this.server.setExecutor(Executors.newCachedThreadPool());
            this.server.start();
            this.plugin.getLogger().info("HTTP-Server l\u00e4uft auf Port " + this.port);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Fehler beim Starten des HTTP-Servers: " + e.getMessage());
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private class ApiHandler
    implements HttpHandler {
        private ApiHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
            exchange.getResponseHeaders().set("Access-Control-Allow-Methods", "GET, OPTIONS");
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", "Content-Type");
            if ("OPTIONS".equalsIgnoreCase(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                this.sendJson(exchange, 405, "error", "Method Not Allowed");
                return;
            }
            Map<String, String> params = this.parseQuery(exchange.getRequestURI().getRawQuery());
            String action = params.get("action");
            if (action == null) {
                this.sendJson(exchange, 400, "error", "Missing action parameter");
                return;
            }
            switch (action.toLowerCase()) {
                case "list": {
                    this.handleList(exchange);
                    break;
                }
                case "check": {
                    this.handleCheck(exchange, params);
                    break;
                }
                case "add": {
                    this.handleModify(exchange, params, true);
                    break;
                }
                case "remove": {
                    this.handleModify(exchange, params, false);
                    break;
                }
                default: {
                    this.sendJson(exchange, 400, "error", "Unknown action");
                }
            }
        }

        private void handleList(HttpExchange exchange) throws IOException {
            Set players = WebServer.this.plugin.getServer().getWhitelistedPlayers();
            StringBuilder sb = new StringBuilder("[");
            for (OfflinePlayer p : players) {
                sb.append("{\"uuid\":\"").append(p.getUniqueId()).append("\",").append("\"name\":\"").append(this.opt(p.getName())).append("\"},");
            }
            if (!players.isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
            this.sendRaw(exchange, 200, sb.toString());
        }

        private void handleCheck(HttpExchange exchange, Map<String, String> params) throws IOException {
            String uuidStr = params.get("uuid");
            if (uuidStr == null || uuidStr.isBlank()) {
                this.sendJson(exchange, 400, "error", "Missing uuid parameter");
                return;
            }
            boolean whitelisted = false;
            String name = null;
            try {
                UUID uuid = UUID.fromString(uuidStr);
                for (OfflinePlayer p : WebServer.this.plugin.getServer().getWhitelistedPlayers()) {
                    if (!p.getUniqueId().equals(uuid)) continue;
                    whitelisted = true;
                    name = p.getName();
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                this.sendJson(exchange, 400, "error", "Invalid uuid format");
                return;
            }
            StringBuilder sb = new StringBuilder("{").append("\"status\":\"ok\",").append("\"whitelisted\":").append(whitelisted);
            if (whitelisted) {
                sb.append(",\"name\":\"").append(this.opt(name)).append("\"");
            }
            sb.append("}");
            this.sendRaw(exchange, 200, sb.toString());
        }

        private void handleModify(HttpExchange exchange, Map<String, String> params, boolean add) throws IOException {
            String name = params.getOrDefault("name", "").trim();
            if (name.isEmpty()) {
                this.sendJson(exchange, 400, "error", "Missing name parameter");
                return;
            }
            Server server = WebServer.this.plugin.getServer();
            OfflinePlayer p = server.getOfflinePlayer(name);
            boolean currently = p.isWhitelisted();
            if (add && currently) {
                this.sendJson(exchange, 200, "error", "Spieler ist bereits gewhitelistet");
                return;
            }
            if (!add && !currently) {
                this.sendJson(exchange, 200, "error", "Spieler ist nicht gewhitelistet");
                return;
            }
            server.getScheduler().runTask((Plugin)WebServer.this.plugin, () -> {
                p.setWhitelisted(add);
                WebServer.this.plugin.getLogger().info("Whitelist: \"" + name + "\" " + (add ? "hinzugef\u00fcgt" : "entfernt"));
            });
            this.sendJson(exchange, 200, "ok", "Spieler " + (add ? "hinzugef\u00fcgt" : "entfernt"));
        }

        private void sendJson(HttpExchange exchange, int code, String status, String message) throws IOException {
            String body = String.format("{\"status\":\"%s\",\"message\":\"%s\"}", status, message.replace("\"", "\\\""));
            this.sendRaw(exchange, code, body);
        }

        private void sendRaw(HttpExchange exchange, int code, String body) throws IOException {
            byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
            exchange.sendResponseHeaders(code, bytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(bytes);
            }
        }

        private Map<String, String> parseQuery(String query) throws UnsupportedEncodingException {
            HashMap<String, String> map = new HashMap<String, String>();
            if (query == null || query.isEmpty()) {
                return map;
            }
            for (String pair : query.split("&")) {
                int idx = pair.indexOf(61);
                if (idx < 0) continue;
                String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name());
                String val = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name());
                map.put(key, val);
            }
            return map;
        }

        private String opt(String s) {
            return s == null ? "" : s.replace("\"", "\\\"");
        }
    }

    private static class ResourceHandler
    implements HttpHandler {
        private final JavaPlugin plugin;

        ResourceHandler(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String resourcePath;
            InputStream in;
            String path = exchange.getRequestURI().getPath();
            if (path == null || path.isBlank() || "/".equals(path)) {
                path = "/index.html";
            }
            if ((in = this.plugin.getResource(resourcePath = "web" + URLDecoder.decode(path, StandardCharsets.UTF_8.name()))) == null) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            byte[] data = ResourceHandler.readAllBytes(in);
            exchange.getResponseHeaders().set("Content-Type", ResourceHandler.guessContentType(resourcePath));
            exchange.sendResponseHeaders(200, data.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(data);
            }
        }

        private static String guessContentType(String name) {
            if (name.endsWith(".html")) {
                return "text/html; charset=UTF-8";
            }
            if (name.endsWith(".css")) {
                return "text/css; charset=UTF-8";
            }
            if (name.endsWith(".js")) {
                return "application/javascript; charset=UTF-8";
            }
            if (name.endsWith(".png")) {
                return "image/png";
            }
            if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            if (name.endsWith(".json")) {
                return "application/json; charset=UTF-8";
            }
            return "application/octet-stream";
        }

        private static byte[] readAllBytes(InputStream in) throws IOException {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            return bos.toByteArray();
        }
    }
}

