/*
 * Decompiled with CFR 0.152.
 */
package de.vmoon.craftAttack.webserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.vmoon.craftAttack.CraftAttack;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ManagementHandler
implements HttpHandler {
    private final JavaPlugin plugin;
    private static final SimpleDateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);

    public ManagementHandler(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Headers headers = exchange.getResponseHeaders();
        headers.set("Access-Control-Allow-Origin", "*");
        headers.set("Access-Control-Allow-Methods", "GET, OPTIONS");
        headers.set("Access-Control-Allow-Headers", "Content-Type");
        if ("OPTIONS".equalsIgnoreCase(exchange.getRequestMethod())) {
            exchange.sendResponseHeaders(204, -1L);
            return;
        }
        if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
            this.sendJson(exchange, 405, "error", "Method Not Allowed");
            return;
        }
        Map<String, String> params = this.parseQuery(exchange.getRequestURI().getRawQuery());
        String action = params.get("action");
        if (action == null) {
            this.sendJson(exchange, 400, "error", "Missing action parameter");
            return;
        }
        switch (action.toLowerCase()) {
            case "kick": {
                this.handleKick(exchange, params);
                break;
            }
            case "ban": {
                this.handleBan(exchange, params);
                break;
            }
            case "unban": {
                this.handleUnban(exchange, params);
                break;
            }
            case "banlist": {
                this.handleBanList(exchange);
                break;
            }
            case "restart": {
                CraftAttack.getInstance().restartServer();
                this.sendJson(exchange, 200, "ok", "Server wird neugestartet.");
                break;
            }
            default: {
                this.sendJson(exchange, 400, "error", "Unknown action");
            }
        }
    }

    private void handleKick(HttpExchange exchange, Map<String, String> params) throws IOException {
        String name = params.getOrDefault("name", "").trim();
        if (name.isEmpty()) {
            this.sendJson(exchange, 400, "error", "Missing name parameter");
            return;
        }
        Player target = Bukkit.getPlayerExact((String)name);
        if (target == null) {
            this.sendJson(exchange, 404, "error", "Spieler " + name + " ist nicht online.");
            return;
        }
        String reason = params.getOrDefault("reason", "Vom Server gekickt");
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> target.kickPlayer(reason));
        this.sendJson(exchange, 200, "ok", "Spieler " + name + " wurde gekickt: " + reason);
    }

    private void handleBan(HttpExchange exchange, Map<String, String> params) throws IOException {
        String name = params.getOrDefault("name", "").trim();
        if (name.isEmpty()) {
            this.sendJson(exchange, 400, "error", "Missing name parameter");
            return;
        }
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
        if (banList.isBanned(name)) {
            this.sendJson(exchange, 200, "error", "Spieler " + name + " ist bereits gebannt.");
            return;
        }
        String reason = params.getOrDefault("reason", "Gebannt von Admin");
        banList.addBan(name, reason, (Date)null, CraftAttack.getInstance().getName());
        Player online = Bukkit.getPlayerExact((String)name);
        if (online != null) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> online.kickPlayer(reason));
        }
        this.sendJson(exchange, 200, "ok", "Spieler " + name + " wurde gebannt: " + reason);
    }

    private void handleUnban(HttpExchange exchange, Map<String, String> params) throws IOException {
        String name = params.getOrDefault("name", "").trim();
        if (name.isEmpty()) {
            this.sendJson(exchange, 400, "error", "Missing name parameter");
            return;
        }
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
        if (!banList.isBanned(name)) {
            this.sendJson(exchange, 200, "error", "Spieler " + name + " ist nicht gebannt.");
            return;
        }
        banList.pardon(name);
        this.sendJson(exchange, 200, "ok", "Spieler " + name + " wurde entbannt.");
    }

    private void handleBanList(HttpExchange exchange) throws IOException {
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
        Set entries = banList.getBanEntries();
        StringBuilder sb = new StringBuilder("[");
        for (BanEntry e : entries) {
            String expires = e.getExpiration() == null ? "null" : "\"" + ISO8601.format(e.getExpiration()) + "\"";
            sb.append("{").append("\"target\":\"").append(this.opt(e.getTarget())).append("\",").append("\"reason\":\"").append(this.opt(e.getReason())).append("\",").append("\"created\":\"").append(ISO8601.format(e.getCreated())).append("\",").append("\"expires\":").append(expires).append(",").append("\"source\":\"").append(this.opt(e.getSource())).append("\"").append("},");
        }
        if (!entries.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        this.sendRaw(exchange, 200, sb.toString());
    }

    private void sendJson(HttpExchange exchange, int code, String status, String message) throws IOException {
        String body = String.format("{\"status\":\"%s\",\"message\":\"%s\"}", status, message.replace("\"", "\\\""));
        this.sendRaw(exchange, code, body);
    }

    private void sendRaw(HttpExchange exchange, int code, String body) throws IOException {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(code, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }

    private Map<String, String> parseQuery(String query) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return map;
        }
        for (String pair : query.split("&")) {
            int idx = pair.indexOf(61);
            if (idx < 0) continue;
            String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name());
            String val = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name());
            map.put(key, val);
        }
        return map;
    }

    private String opt(String s) {
        return s == null ? "" : s.replace("\"", "\\\"");
    }

    static {
        ISO8601.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

