/*
 * Decompiled with CFR 0.152.
 */
package ru.zoga_com.chatless.managers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zoga_com.chatless.Main;
import ru.zoga_com.chatless.managers.ConfigManager;
import ru.zoga_com.chatless.types.Chat;
import ru.zoga_com.chatless.util.Style;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\u001c\u0010 \u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lru/zoga_com/chatless/managers/ChatManager;", "", "()V", "chatMap", "", "", "Lru/zoga_com/chatless/types/Chat;", "replies", "Lcom/google/common/cache/Cache;", "swearRegex", "getSwearRegex", "()Ljava/lang/String;", "escape", "input", "featureFormatting", "message", "player", "Lorg/bukkit/entity/Player;", "getChatBySymbol", "symbol", "getCooldown", "", "chat", "getReply", "to", "hideSwears", "Lnet/kyori/adventure/text/Component;", "initializeChats", "", "logCorruptedChat", "field", "returnMessage", "sendSpy", "receivers", "", "setCooldown", "updateReply", "from", "chatless"})
@SourceDebugExtension(value={"SMAP\nChatManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatManager.kt\nru/zoga_com/chatless/managers/ChatManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1855#2,2:121\n1855#2:123\n1747#2,3:124\n1856#2:127\n1855#2,2:128\n*S KotlinDebug\n*F\n+ 1 ChatManager.kt\nru/zoga_com/chatless/managers/ChatManager\n*L\n28#1:121,2\n64#1:123\n65#1:124,3\n64#1:127\n92#1:128,2\n*E\n"})
public final class ChatManager {
    @NotNull
    public static final ChatManager INSTANCE = new ChatManager();
    @NotNull
    private static final String swearRegex = "(?<=(^|[^\u0430-\u044f]))((\u0443|[\u043d\u0437]\u0430|(\u0445\u0438\u0442\u0440\u043e|\u043d\u0435)?\u0432\u0437?[\u044b\u044c\u044a]|\u0441[\u044c\u044a]|(\u0438|\u0440\u0430)[\u0437\u0441]\u044a?|(\u043e[\u0442\u0431]|\u043f\u043e\u0434)[\u044c\u044a]?|(.\\\\B)+?[\u043e\u0430\u0435\u0438])?-?([\u0435\u0451]\u0431(?!\u043e[\u0440\u0439])|\u0438[\u043f\u0431][\u0430\u0435][\u0442\u0446]).*?|(\u043d[\u0438\u0435\u0430]|([\u0434\u043f]|\u0432\u0435\u0440\u0442)\u043e|\u0440\u0430[\u0437\u0441]|\u0437?\u0430|\u0441(\u043c\u0435)?|\u043e(\u0442|\u0434\u043d\u043e)?|\u0430\u043f\u0447)?-?\u0445\u0443([\u044f\u0439\u0438\u0435\u0451\u044e]|\u043b\u0438(?!\u0433\u0430\u043d)).*?|(\u0432[\u0437\u044b]|(\u0442\u0440\u0438|\u0434\u0432\u0430|\u0447\u0435\u0442\u044b\u0440\u0435)\u0436\u0434\u044b|(\u043d|\u0441\u0443\u043a)\u0430)?-?\u0431\u043b(\u044f(?!(\u0445|\u0448[\u043a\u043d]|\u043c\u0431)[\u0430\u0443\u0435\u044b\u0438\u043e]).*?|[\u0435\u044d][\u0434\u0442]\u044c?)|(\u0440\u0430[\u0441\u0437]|[\u0437\u043d]\u0430|[\u0441\u043e]|\u0432\u044b?|\u043f(\u0435\u0440\u0435|\u0440[\u043e\u0438\u0435]|\u043e\u0434)|\u0438[\u0437\u0441]\u044a?|[\u0430\u043e]\u0442)?\u043f[\u0438\u0435\u0451]\u0437\u0434.*?|(\u0437\u0430)?\u043f[\u0438\u0435]\u0434[\u0430\u043e\u0435]?\u0440(\u043d\u0443.*?|[\u043e\u0430]\u043c|(\u0430\u0441)?(\u0438(\u043b\u0438)?[\u043d\u0449\u043a\u0442\u043b]\u044c?)?|(\u043e(\u0447[\u0435\u0438])?|\u0430\u0441)?\u043a(\u043e\u0439)|\u044e\u0433)[\u0430\u0443\u0435\u044b]?|\u043c\u0430\u043d\u0434([\u0430\u0443\u0435\u044b\u0438](\u043b(\u0438[\u0441\u0437\u0449])?[\u0430\u0443\u0435\u0438\u044b])?|\u043e\u0439|[\u0430\u043e]\u0432\u043e\u0448\u044c?(\u0435?\u043a[\u0430\u0443\u0435])?|\u044e\u043a(\u043e\u0432|[\u0430\u0443\u0438])?)|\u043c\u0443\u0434([\u044f\u0430\u0438\u043e].*?|\u0435?\u043d([\u044c\u044e\u0438\u044f]|\u0435\u0439))|\u043c\u043b\u044f([\u0442\u0434]\u044c)?|\u043b\u044f\u0442\u044c|([\u043d\u0437]\u0430|\u043f\u043e)\u0445|\u043c[\u0430\u043e]\u043b[\u0430\u043e]\u0444\u044c([\u044f\u0438\u044e]|[\u0435\u0451\u043e]\u0439))(?=($|[^\u0430-\u044f]))";
    @NotNull
    private static Map<String, Chat> chatMap = new LinkedHashMap();
    @NotNull
    private static Cache<String, String> replies;

    private ChatManager() {
    }

    @NotNull
    public final String getSwearRegex() {
        return swearRegex;
    }

    public final void initializeChats() {
        chatMap = new LinkedHashMap();
        Iterable $this$forEach$iv = ConfigManager.INSTANCE.getChats();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurationSection it = (ConfigurationSection)element$iv;
            boolean bl = false;
            Map<String, Chat> map2 = chatMap;
            String string = it.getString("symbol", "null");
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            boolean bl2 = it.getBoolean("enabled", true);
            String string3 = it.getString("format");
            if (string3 == null) {
                String string4 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                string3 = INSTANCE.logCorruptedChat(string4, "format", "{player}: {message}");
            }
            Object object = string3;
            Intrinsics.checkNotNull(object);
            int n = it.getInt("range", -2);
            String string5 = it.getString("permission");
            String string6 = it.getString("symbol", "null");
            Intrinsics.checkNotNull(string6);
            object = new Chat(string2, bl2, (String)object, n, string5, string6, it.getInt("cooldown", 0));
            map2.put(string, (Chat)object);
        }
    }

    @NotNull
    public final String logCorruptedChat(@NotNull String chat, @NotNull String field, @NotNull String returnMessage) {
        Intrinsics.checkNotNullParameter(chat, "chat");
        Intrinsics.checkNotNullParameter(field, "field");
        Intrinsics.checkNotNullParameter(returnMessage, "returnMessage");
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        plugin.getLogger().warning(chat + " corrupted! " + field + " is null! Using default value.");
        return returnMessage;
    }

    @Nullable
    public final Chat getChatBySymbol(@NotNull String symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Chat chat = chatMap.get(symbol);
        if (chat == null) {
            chat = chatMap.get("null");
        }
        return chat;
    }

    public final void setCooldown(@NotNull Player player, @NotNull Chat chat) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(chat, "chat");
        String string = "chatless.cooldown." + chat.getTechName();
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        player.setMetadata(string, (MetadataValue)new FixedMetadataValue(plugin, (Object)System.currentTimeMillis()));
    }

    public final boolean getCooldown(@NotNull Player player, @NotNull Chat chat) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(chat, "chat");
        if (player.getMetadata("chatless.cooldown." + chat.getTechName()).isEmpty()) {
            return false;
        }
        return ((MetadataValue)player.getMetadata("chatless.cooldown." + chat.getTechName()).get(0)).asLong() > System.currentTimeMillis() - (long)(chat.getCooldown() * 1000);
    }

    public final void sendSpy(@NotNull Component message, @NotNull List<String> receivers) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(receivers, "receivers");
        Iterable $this$forEach$iv = ConfigManager.INSTANCE.getSpyList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String it;
            block4: {
                it = (String)element$iv;
                boolean bl2 = false;
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Player f = (Player)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it, f.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl || receivers.contains(it)) continue;
            Player player = Bukkit.getPlayer((String)it);
            Intrinsics.checkNotNull(player);
            player.sendMessage(Style.INSTANCE.ampersand(ConfigManager.INSTANCE.getMessage("messages.spy-format")).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{chat}").replacement((ComponentLike)message).build()));
        }
    }

    @NotNull
    public final String featureFormatting(@NotNull String message, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(player, "player");
        Object formattedMessage = message;
        List list = player.getMetadata("chatless.feature.autoupper");
        Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
        if (!((Collection)list).isEmpty() && ((MetadataValue)player.getMetadata("chatless.feature.autoupper").get(0)).asInt() == 1) {
            formattedMessage = StringsKt.capitalize((String)formattedMessage);
        }
        List list2 = player.getMetadata("chatless.feature.autopoint");
        Intrinsics.checkNotNullExpressionValue(list2, "getMetadata(...)");
        if (!((Collection)list2).isEmpty() && ((MetadataValue)player.getMetadata("chatless.feature.autopoint").get(0)).asInt() == 1) {
            formattedMessage = (String)formattedMessage + ".";
        }
        return formattedMessage;
    }

    @NotNull
    public final Component hideSwears(@NotNull Component message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Object[] resultString = null;
        resultString = new String[]{};
        String string = PlainTextComponentSerializer.plainText().serialize(message);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        String[] stringArray = new String[]{" "};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Pattern pattern = Pattern.compile(swearRegex);
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            resultString = ArraysKt.plus(resultString, pattern.matcher(string2).find() ? StringsKt.repeat("*", it.length()) : it);
        }
        TextReplacementConfig.Builder builder = TextReplacementConfig.builder();
        String string3 = PlainTextComponentSerializer.plainText().serialize(message);
        Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
        stringArray = message.replaceText((TextReplacementConfig)builder.match(this.escape(string3)).replacement(ArraysKt.joinToString$default(resultString, (CharSequence)" ", null, null, 0, null, null, 62, null)).build());
        Intrinsics.checkNotNullExpressionValue(stringArray, "replaceText(...)");
        return stringArray;
    }

    public final void updateReply(@NotNull String to, @NotNull String from) {
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(from, "from");
        if (replies.getIfPresent((Object)to) != null) {
            replies.invalidate((Object)to);
        }
        replies.put((Object)to, (Object)from);
    }

    @Nullable
    public final String getReply(@NotNull String to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return (String)replies.getIfPresent((Object)to);
    }

    private final String escape(String input) {
        String string = new String(input).replaceAll("[\\W]", "\\\\$0");
        Intrinsics.checkNotNullExpressionValue(string, "replaceAll(...)");
        return string;
    }

    static {
        Cache cache2 = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(1000).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue(cache2, "build(...)");
        replies = cache2;
    }
}

