/*
 * Decompiled with CFR 0.152.
 */
package ru.zoga_com.chatless.types;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zoga_com.chatless.Main;
import ru.zoga_com.chatless.managers.ChatManager;
import ru.zoga_com.chatless.managers.ConfigManager;
import ru.zoga_com.chatless.util.Style;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003JQ\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\bH\u00d6\u0001J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006'"}, d2={"Lru/zoga_com/chatless/types/Chat;", "", "techName", "", "enabled", "", "format", "range", "", "permission", "symbol", "cooldown", "(Ljava/lang/String;ZLjava/lang/String;ILjava/lang/String;Ljava/lang/String;I)V", "getCooldown", "()I", "getEnabled", "()Z", "getFormat", "()Ljava/lang/String;", "getPermission", "getRange", "getSymbol", "getTechName", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "sendMessage", "", "eventObject", "Lio/papermc/paper/event/player/AsyncChatEvent;", "toString", "chatless"})
@SourceDebugExtension(value={"SMAP\nChat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Chat.kt\nru/zoga_com/chatless/types/Chat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n1855#2,2:125\n1855#2,2:127\n*S KotlinDebug\n*F\n+ 1 Chat.kt\nru/zoga_com/chatless/types/Chat\n*L\n66#1:123,2\n81#1:125,2\n99#1:127,2\n*E\n"})
public final class Chat {
    @NotNull
    private final String techName;
    private final boolean enabled;
    @NotNull
    private final String format;
    private final int range;
    @Nullable
    private final String permission;
    @NotNull
    private final String symbol;
    private final int cooldown;

    public Chat(@NotNull String techName, boolean enabled, @NotNull String format, int range, @Nullable String permission, @NotNull String symbol, int cooldown) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        this.techName = techName;
        this.enabled = enabled;
        this.format = format;
        this.range = range;
        this.permission = permission;
        this.symbol = symbol;
        this.cooldown = cooldown;
    }

    public /* synthetic */ Chat(String string, boolean bl, String string2, int n, String string3, String string4, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            string3 = null;
        }
        this(string, bl, string2, n, string3, string4, n2);
    }

    @NotNull
    public final String getTechName() {
        return this.techName;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final int getRange() {
        return this.range;
    }

    @Nullable
    public final String getPermission() {
        return this.permission;
    }

    @NotNull
    public final String getSymbol() {
        return this.symbol;
    }

    public final int getCooldown() {
        return this.cooldown;
    }

    public final void sendMessage(@NotNull AsyncChatEvent eventObject) {
        Intrinsics.checkNotNullParameter(eventObject, "eventObject");
        Player player = eventObject.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (ChatManager.INSTANCE.getCooldown(player, this)) {
            eventObject.getPlayer().sendMessage((Component)Style.INSTANCE.ampersand(ConfigManager.INSTANCE.getMessage("messages.cooldown-message")));
            return;
        }
        String finishFormat = this.format;
        if (Main.Companion.getPAPI_STATE()) {
            Player player2 = eventObject.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            finishFormat = Style.INSTANCE.replacePlaceholders(this.format, player2);
        }
        Component component = eventObject.message().replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(Intrinsics.areEqual(this.symbol, "null") ? "" : this.symbol).replacement("").build());
        Intrinsics.checkNotNullExpressionValue(component, "replaceText(...)");
        Component buildedMessage = component;
        String string = PlainTextComponentSerializer.plainText().serialize(buildedMessage);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        Player player3 = eventObject.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player3, "getPlayer(...)");
        TextComponent textComponent = Component.text((String)ChatManager.INSTANCE.featureFormatting(string, player3));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        TextComponent styledMessagePart = textComponent;
        Component component2 = Style.INSTANCE.ampersand(finishFormat).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{message}").replacement((ComponentLike)styledMessagePart).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{player}").replacement((ComponentLike)eventObject.getPlayer().name()).build());
        Intrinsics.checkNotNullExpressionValue(component2, "replaceText(...)");
        Component formattedMessage = component2;
        Component component3 = Style.INSTANCE.ampersand(finishFormat).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{message}").replacement((ComponentLike)ChatManager.INSTANCE.hideSwears((Component)styledMessagePart)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("\\{player}").replacement((ComponentLike)eventObject.getPlayer().name()).build());
        Intrinsics.checkNotNullExpressionValue(component3, "replaceText(...)");
        Component noSwearMessage = component3;
        if (this.range == -2) {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!ConfigManager.INSTANCE.isEnabledSetting(it, "filter-swear")) {
                    it.sendMessage(noSwearMessage);
                } else {
                    it.sendMessage(formattedMessage);
                }
                String string2 = PlainTextComponentSerializer.plainText().serialize(buildedMessage);
                Intrinsics.checkNotNullExpressionValue(string2, "serialize(...)");
                String[] stringArray = new String[]{" "};
                if (!StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null).contains(it.getName())) continue;
                it.playSound(it.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
            Bukkit.getConsoleSender().sendMessage(formattedMessage);
        } else if (this.range == -1) {
            List receivers = new ArrayList();
            List list = eventObject.getPlayer().getLocation().getWorld().getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!ConfigManager.INSTANCE.isEnabledSetting(it, "filter-swear")) {
                    it.sendMessage(noSwearMessage);
                } else {
                    it.sendMessage(formattedMessage);
                }
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                receivers.add(string3);
                String string4 = PlainTextComponentSerializer.plainText().serialize(buildedMessage);
                Intrinsics.checkNotNullExpressionValue(string4, "serialize(...)");
                String[] stringArray = new String[]{" "};
                if (!StringsKt.split$default((CharSequence)string4, stringArray, false, 0, 6, null).contains(it.getName())) continue;
                it.playSound(it.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
            ChatManager.INSTANCE.sendSpy(formattedMessage, receivers);
            Bukkit.getConsoleSender().sendMessage(formattedMessage);
        } else if (this.range >= 0) {
            List receivers = new ArrayList();
            BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
            Plugin plugin = Main.Companion.getInstance();
            Intrinsics.checkNotNull(plugin);
            bukkitScheduler.scheduleSyncDelayedTask(plugin, () -> Chat.sendMessage$lambda$3(eventObject, this, formattedMessage, receivers, noSwearMessage, buildedMessage));
            Bukkit.getConsoleSender().sendMessage(formattedMessage);
        } else {
            ChatManager.INSTANCE.logCorruptedChat(this.techName, "range", "Default range set");
        }
        Player player4 = eventObject.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player4, "getPlayer(...)");
        ChatManager.INSTANCE.setCooldown(player4, this);
    }

    @NotNull
    public final String component1() {
        return this.techName;
    }

    public final boolean component2() {
        return this.enabled;
    }

    @NotNull
    public final String component3() {
        return this.format;
    }

    public final int component4() {
        return this.range;
    }

    @Nullable
    public final String component5() {
        return this.permission;
    }

    @NotNull
    public final String component6() {
        return this.symbol;
    }

    public final int component7() {
        return this.cooldown;
    }

    @NotNull
    public final Chat copy(@NotNull String techName, boolean enabled, @NotNull String format, int range, @Nullable String permission, @NotNull String symbol, int cooldown) {
        Intrinsics.checkNotNullParameter(techName, "techName");
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return new Chat(techName, enabled, format, range, permission, symbol, cooldown);
    }

    public static /* synthetic */ Chat copy$default(Chat chat, String string, boolean bl, String string2, int n, String string3, String string4, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = chat.techName;
        }
        if ((n3 & 2) != 0) {
            bl = chat.enabled;
        }
        if ((n3 & 4) != 0) {
            string2 = chat.format;
        }
        if ((n3 & 8) != 0) {
            n = chat.range;
        }
        if ((n3 & 0x10) != 0) {
            string3 = chat.permission;
        }
        if ((n3 & 0x20) != 0) {
            string4 = chat.symbol;
        }
        if ((n3 & 0x40) != 0) {
            n2 = chat.cooldown;
        }
        return chat.copy(string, bl, string2, n, string3, string4, n2);
    }

    @NotNull
    public String toString() {
        return "Chat(techName=" + this.techName + ", enabled=" + this.enabled + ", format=" + this.format + ", range=" + this.range + ", permission=" + this.permission + ", symbol=" + this.symbol + ", cooldown=" + this.cooldown + ")";
    }

    public int hashCode() {
        int result2 = this.techName.hashCode();
        int n = this.enabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + this.format.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.range);
        result2 = result2 * 31 + (this.permission == null ? 0 : this.permission.hashCode());
        result2 = result2 * 31 + this.symbol.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.cooldown);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Chat)) {
            return false;
        }
        Chat chat = (Chat)other;
        if (!Intrinsics.areEqual(this.techName, chat.techName)) {
            return false;
        }
        if (this.enabled != chat.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.format, chat.format)) {
            return false;
        }
        if (this.range != chat.range) {
            return false;
        }
        if (!Intrinsics.areEqual(this.permission, chat.permission)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.symbol, chat.symbol)) {
            return false;
        }
        return this.cooldown == chat.cooldown;
    }

    private static final void sendMessage$lambda$3(AsyncChatEvent $eventObject, Chat this$0, Component $formattedMessage, List $receivers, Component $noSwearMessage, Component $buildedMessage) {
        Intrinsics.checkNotNullParameter($eventObject, "$eventObject");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($formattedMessage, "$formattedMessage");
        Intrinsics.checkNotNullParameter($receivers, "$receivers");
        Intrinsics.checkNotNullParameter($noSwearMessage, "$noSwearMessage");
        Intrinsics.checkNotNullParameter($buildedMessage, "$buildedMessage");
        Collection collection = $eventObject.getPlayer().getLocation().getNearbyPlayers((double)this$0.range);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyPlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!ConfigManager.INSTANCE.isEnabledSetting(it, "filter-swear")) {
                it.sendMessage($noSwearMessage);
            } else {
                it.sendMessage($formattedMessage);
            }
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            $receivers.add(string);
            String string2 = PlainTextComponentSerializer.plainText().serialize($buildedMessage);
            Intrinsics.checkNotNullExpressionValue(string2, "serialize(...)");
            String[] stringArray = new String[]{" "};
            if (!StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null).contains(it.getName())) continue;
            it.playSound(it.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        ChatManager.INSTANCE.sendSpy($formattedMessage, $receivers);
    }
}

