/*
 * Decompiled with CFR 0.152.
 */
package ru.zoga_com.chatless.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.zoga_com.chatless.Main;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\r\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0014J\u0016\u0010\"\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lru/zoga_com/chatless/managers/ConfigManager;", "", "()V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "joinAndQuitMessages", "", "getJoinAndQuitMessages", "()Z", "setJoinAndQuitMessages", "(Z)V", "spyList", "", "", "getSpyList", "()Ljava/util/List;", "setSpyList", "(Ljava/util/List;)V", "temp", "addSpy", "", "player", "Lorg/bukkit/entity/Player;", "getChats", "", "Lorg/bukkit/configuration/ConfigurationSection;", "getMessage", "key", "getStates", "", "", "setting", "(Ljava/lang/String;)[Ljava/lang/Integer;", "inititialize", "isEnabledSetting", "removeSpy", "setSetting", "state", "chatless"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nru/zoga_com/chatless/managers/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nru/zoga_com/chatless/managers/ConfigManager\n*L\n19#1:76,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static FileConfiguration config;
    private static FileConfiguration temp;
    @NotNull
    private static List<String> spyList;
    private static boolean joinAndQuitMessages;

    private ConfigManager() {
    }

    @NotNull
    public final List<String> getSpyList() {
        return spyList;
    }

    public final void setSpyList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        spyList = list;
    }

    public final boolean getJoinAndQuitMessages() {
        return joinAndQuitMessages;
    }

    public final void setJoinAndQuitMessages(boolean bl) {
        joinAndQuitMessages = bl;
    }

    @NotNull
    public final List<ConfigurationSection> getChats() {
        List chats = new ArrayList();
        FileConfiguration fileConfiguration = config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("chats");
        Intrinsics.checkNotNull(configurationSection);
        Set set = configurationSection.getKeys(false);
        Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            FileConfiguration fileConfiguration2 = config;
            if (fileConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("config");
                fileConfiguration2 = null;
            }
            ConfigurationSection configurationSection2 = fileConfiguration2.getConfigurationSection("chats");
            Intrinsics.checkNotNull(configurationSection2);
            ConfigurationSection configurationSection3 = configurationSection2.getConfigurationSection(it);
            Intrinsics.checkNotNull(configurationSection3);
            chats.add(configurationSection3);
        }
        return chats;
    }

    @NotNull
    public final Integer[] getStates(@NotNull String setting) {
        Intrinsics.checkNotNullParameter(setting, "setting");
        FileConfiguration fileConfiguration = config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        boolean value = fileConfiguration.getBoolean("default-settings." + setting, false);
        Integer[] integerArray = new Integer[]{value ? 1 : 0, value ? 0 : 1};
        return integerArray;
    }

    public final void inititialize() {
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "config.yml"));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        config = (FileConfiguration)yamlConfiguration;
        Plugin plugin2 = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin2);
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)new File(plugin2.getDataFolder(), "temp.yml"));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        temp = (FileConfiguration)yamlConfiguration2;
        FileConfiguration fileConfiguration = temp;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration = null;
        }
        List list = fileConfiguration.getStringList("spy");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        spyList = list;
        FileConfiguration fileConfiguration2 = config;
        if (fileConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration2 = null;
        }
        joinAndQuitMessages = fileConfiguration2.getBoolean("join-quit-messages");
    }

    @NotNull
    public final String getMessage(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        FileConfiguration fileConfiguration = config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        if ((object = fileConfiguration.getString(key, key)) == null) {
            object = "Message `" + key + "` not found.";
        }
        return object;
    }

    public final void addSpy(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        FileConfiguration fileConfiguration = temp;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration = null;
        }
        List list = fileConfiguration.getStringList("spy");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List tempList = list;
        tempList.add(player.getName());
        FileConfiguration fileConfiguration2 = temp;
        if (fileConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration2 = null;
        }
        fileConfiguration2.set("spy", (Object)tempList);
        FileConfiguration fileConfiguration3 = temp;
        if (fileConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration3 = null;
        }
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        fileConfiguration3.save(new File(plugin.getDataFolder(), "temp.yml"));
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        spyList.add(string);
    }

    public final void removeSpy(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        FileConfiguration fileConfiguration = temp;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration = null;
        }
        List list = fileConfiguration.getStringList("spy");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List tempList = list;
        tempList.remove(player.getName());
        FileConfiguration fileConfiguration2 = temp;
        if (fileConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration2 = null;
        }
        fileConfiguration2.set("spy", (Object)tempList);
        FileConfiguration fileConfiguration3 = temp;
        if (fileConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration3 = null;
        }
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        fileConfiguration3.save(new File(plugin.getDataFolder(), "temp.yml"));
        spyList.remove(player.getName());
    }

    public final void setSetting(@NotNull Player player, @NotNull String setting, boolean state) {
        FileConfiguration fileConfiguration;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(setting, "setting");
        FileConfiguration fileConfiguration2 = temp;
        if (fileConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration2 = null;
        }
        List list = fileConfiguration2.getStringList(setting);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List tempList = list;
        if (state) {
            if (!tempList.contains(player.getName())) {
                tempList.add(player.getName());
                String string = "chatless.feature." + setting;
                Plugin plugin = Main.Companion.getInstance();
                Intrinsics.checkNotNull(plugin);
                player.setMetadata(string, (MetadataValue)new FixedMetadataValue(plugin, (Object)1));
            }
        } else {
            tempList.remove(player.getName());
            String string = "chatless.feature." + setting;
            Plugin plugin = Main.Companion.getInstance();
            Intrinsics.checkNotNull(plugin);
            player.setMetadata(string, (MetadataValue)new FixedMetadataValue(plugin, (Object)0));
        }
        if ((fileConfiguration = temp) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration = null;
        }
        fileConfiguration.set(setting, (Object)tempList);
        FileConfiguration fileConfiguration3 = temp;
        if (fileConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration3 = null;
        }
        Plugin plugin = Main.Companion.getInstance();
        Intrinsics.checkNotNull(plugin);
        fileConfiguration3.save(new File(plugin.getDataFolder(), "temp.yml"));
    }

    public final boolean isEnabledSetting(@NotNull Player player, @NotNull String setting) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(setting, "setting");
        FileConfiguration fileConfiguration = temp;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("temp");
            fileConfiguration = null;
        }
        return fileConfiguration.getStringList(setting).contains(player.getName());
    }

    static {
        spyList = new ArrayList();
    }
}

