/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.blockdisplayposer.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_8113;
import net.minecraft.class_8710;
import net.sixunderscore.blockdisplayposer.BlockDisplayPoser;
import net.sixunderscore.blockdisplayposer.network.OpenDisplayScreenPayload;
import net.sixunderscore.blockdisplayposer.util.DisplayEntityAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ModCommands {
    public static void register() {
        BlockDisplayPoser.LOGGER.info("Registering commands");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"editblockdisplay").executes(ModCommands::editCommand)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"createblockdisplay").executes(ModCommands::createCommand)));
    }

    private static int editCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player != null) {
            class_8113 display = ModCommands.rayCastDisplayEntities((class_1657)player);
            if (display != null) {
                if (display instanceof DisplayEntityAccessor) {
                    class_2680 class_26802;
                    DisplayEntityAccessor accessor = (DisplayEntityAccessor)display;
                    int packedLight = accessor.getBrightness();
                    class_243 pos = display.method_19538();
                    int n = display.method_5628();
                    Vector3f vector3f = new Vector3f((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
                    Quaternionf quaternionf = accessor.getRotation();
                    Vector3f vector3f2 = accessor.getScale();
                    if (display instanceof class_8113.class_8115) {
                        class_8113.class_8115 blockDisplay = (class_8113.class_8115)display;
                        class_26802 = blockDisplay.method_48884();
                    } else {
                        class_26802 = null;
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenDisplayScreenPayload(n, vector3f, quaternionf, vector3f2, class_26802, packedLight >> 4 & 0xF, packedLight >> 20 & 0xF, accessor.getViewRange()));
                }
            } else {
                source.method_45068((class_2561)class_2561.method_43470((String)"You must be looking at a display entity"));
                return 0;
            }
        }
        return 1;
    }

    private static int createCommand(CommandContext<class_2168> context) {
        class_243 lookVec;
        class_243 targetPos;
        class_243 eyePos;
        class_3965 hitResult;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        class_3218 world = source.method_9225();
        if (player != null && (hitResult = world.method_17742(new class_3959(eyePos = player.method_5836(1.0f), targetPos = eyePos.method_1019((lookVec = player.method_5828(1.0f)).method_1021(500.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player))).method_17783() == class_239.class_240.field_1332) {
            class_2680 blockState = world.method_8320(hitResult.method_17777());
            class_2338 playerPos = player.method_24515();
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof class_2484) {
                class_2484 skullBlock = (class_2484)class_22482;
                class_1799 skullStack = new class_1799((class_1935)skullBlock.method_8389());
                class_8113.class_8122 itemDisplayEntity = new class_8113.class_8122(class_1299.field_42456, (class_1937)world);
                itemDisplayEntity.method_5814((double)((float)playerPos.method_10263() - 0.5f), (double)((float)playerPos.method_10264() + 0.5f), (double)((float)playerPos.method_10260() - 0.5f));
                itemDisplayEntity.method_48897(skullStack);
                world.method_8649((class_1297)itemDisplayEntity);
            } else {
                class_8113.class_8115 blockDisplayEntity = new class_8113.class_8115(class_1299.field_42460, (class_1937)world);
                blockDisplayEntity.method_5814((double)playerPos.method_10263(), (double)playerPos.method_10264(), (double)playerPos.method_10260());
                blockDisplayEntity.method_48883(blockState);
                if (blockDisplayEntity instanceof DisplayEntityAccessor) {
                    DisplayEntityAccessor accessor = (DisplayEntityAccessor)blockDisplayEntity;
                    accessor.setBrightness(0, 15);
                }
                world.method_8649((class_1297)blockDisplayEntity);
            }
        }
        return 1;
    }

    @Nullable
    private static class_8113 rayCastDisplayEntities(class_1657 player) {
        class_243 playerPos = player.method_19538();
        double range = 50.0;
        class_238 searchBox = new class_238(playerPos.method_1031(-range, -range, -range), playerPos.method_1031(range, range, range));
        List totalDisplays = player.method_37908().method_8390(class_8113.class, searchBox, displayEntity -> true);
        if (!totalDisplays.isEmpty()) {
            class_243 start = player.method_33571();
            class_243 end = start.method_1019(player.method_5828(1.0f).method_1021(50.0));
            class_8113 selectedDisplay = null;
            double closestDistanceSq = Double.MAX_VALUE;
            for (class_8113 display : totalDisplays) {
                double distanceSq;
                if (!(display instanceof DisplayEntityAccessor)) continue;
                DisplayEntityAccessor accessor = (DisplayEntityAccessor)display;
                Vector3f scale = accessor.getScale();
                class_238 displayBox = new class_238(display.method_23317(), display.method_23318(), display.method_23321(), display.method_23317() + (double)scale.x, display.method_23318() + (double)scale.y, display.method_23321() + (double)scale.z);
                Optional hit = displayBox.method_992(start, end);
                if (!hit.isPresent() || !((distanceSq = start.method_1025((class_243)hit.get())) < closestDistanceSq)) continue;
                closestDistanceSq = distanceSq;
                selectedDisplay = display;
            }
            return selectedDisplay;
        }
        return null;
    }
}

