/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.blockdisplayposer.network;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8113;
import net.sixunderscore.blockdisplayposer.BlockDisplayPoser;
import net.sixunderscore.blockdisplayposer.network.CloneDisplayPayload;
import net.sixunderscore.blockdisplayposer.network.DeleteDisplayPayload;
import net.sixunderscore.blockdisplayposer.network.OpenDisplayScreenPayload;
import net.sixunderscore.blockdisplayposer.network.SendDisplayBlockStatePayload;
import net.sixunderscore.blockdisplayposer.network.SendDisplayNumericDataPayload;
import net.sixunderscore.blockdisplayposer.util.DisplayEntityAccessor;
import org.joml.Vector3f;

public class Packets {
    public static final class_2960 OPEN_SCREEN_PAYLOAD = class_2960.method_60655((String)"blockdisplayposer", (String)"open_screen");
    public static final class_2960 SEND_BLOCKSTATE = class_2960.method_60655((String)"blockdisplayposer", (String)"send_blockstate");
    public static final class_2960 SEND_NUM_DATA = class_2960.method_60655((String)"blockdisplayposer", (String)"send_num_data");
    public static final class_2960 DELETE = class_2960.method_60655((String)"blockdisplayposer", (String)"delete");
    public static final class_2960 CLONE = class_2960.method_60655((String)"blockdisplayposer", (String)"clone");

    public static void register() {
        BlockDisplayPoser.LOGGER.info("Registering server side packet listeners");
        PayloadTypeRegistry.playS2C().register(OpenDisplayScreenPayload.ID, OpenDisplayScreenPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SendDisplayBlockStatePayload.ID, SendDisplayBlockStatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SendDisplayBlockStatePayload.ID, SendDisplayBlockStatePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SendDisplayNumericDataPayload.ID, SendDisplayNumericDataPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SendDisplayNumericDataPayload.ID, SendDisplayNumericDataPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(DeleteDisplayPayload.ID, DeleteDisplayPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CloneDisplayPayload.ID, CloneDisplayPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SendDisplayBlockStatePayload.ID, (payload, context) -> {
            class_1297 entity = context.player().method_51469().method_8469(payload.blockDisplayEntityId());
            if (entity instanceof class_8113.class_8115) {
                class_8113.class_8115 blockDisplay = (class_8113.class_8115)entity;
                class_2680 state = payload.blockState();
                if (state != null) {
                    blockDisplay.method_48883(state);
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SendDisplayNumericDataPayload.ID, (payload, context) -> {
            class_1297 entity = context.player().method_51469().method_8469(payload.blockDisplayEntityId());
            if (entity instanceof class_8113) {
                class_8113 blockDisplay = (class_8113)entity;
                Vector3f position = payload.position();
                blockDisplay.method_5814((double)position.x, (double)position.y, (double)position.z);
                if (blockDisplay instanceof DisplayEntityAccessor) {
                    DisplayEntityAccessor accessor = (DisplayEntityAccessor)blockDisplay;
                    accessor.setRotation(payload.rotation());
                    accessor.setScale(payload.scale());
                    accessor.setBrightness(payload.blockBrightness(), payload.skyBrightness());
                    accessor.setViewRange(payload.viewDistance());
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(DeleteDisplayPayload.ID, (payload, context) -> {
            class_1297 entity = context.player().method_51469().method_8469(payload.blockDisplayEntityId());
            if (entity instanceof class_8113) {
                class_8113 blockDisplay = (class_8113)entity;
                blockDisplay.method_31472();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(CloneDisplayPayload.ID, (payload, context) -> {
            class_1297 entity;
            class_3222 player = context.player();
            class_3218 world = context.player().method_51469();
            if (player != null && (entity = context.player().method_51469().method_8469(payload.blockDisplayEntityId())) instanceof class_8113) {
                class_8113 targetDisplay = (class_8113)entity;
                class_2338 playerPos = player.method_24515();
                if (targetDisplay instanceof class_8113.class_8115) {
                    class_8113.class_8115 targetBlockDisplay = (class_8113.class_8115)targetDisplay;
                    if (targetDisplay instanceof DisplayEntityAccessor) {
                        DisplayEntityAccessor targetAccessor = (DisplayEntityAccessor)targetDisplay;
                        class_8113.class_8115 newDisplay = new class_8113.class_8115(class_1299.field_42460, (class_1937)world);
                        newDisplay.method_5814((double)playerPos.method_10263(), (double)playerPos.method_10264(), (double)playerPos.method_10260());
                        newDisplay.method_48883(targetBlockDisplay.method_48884());
                        if (newDisplay instanceof DisplayEntityAccessor) {
                            DisplayEntityAccessor newAccessor = (DisplayEntityAccessor)newDisplay;
                            newAccessor.setRotation(targetAccessor.getRotation());
                            newAccessor.setScale(targetAccessor.getScale());
                            newAccessor.setViewRange(targetAccessor.getViewRange());
                            int packedLight = targetAccessor.getBrightness();
                            newAccessor.setBrightness(packedLight >> 4 & 0xF, packedLight >> 20 & 0xF);
                        }
                        world.method_8649((class_1297)newDisplay);
                    }
                }
            }
        });
    }
}

