/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.blockdisplayposer.screen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_8710;
import net.sixunderscore.blockdisplayposer.network.CloneDisplayPayload;
import net.sixunderscore.blockdisplayposer.network.DeleteDisplayPayload;
import net.sixunderscore.blockdisplayposer.network.SendDisplayBlockStatePayload;
import net.sixunderscore.blockdisplayposer.network.SendDisplayNumericDataPayload;
import net.sixunderscore.blockdisplayposer.screen.NumericFieldWidget;
import net.sixunderscore.blockdisplayposer.screen.ScaleFieldWidget;
import net.sixunderscore.blockdisplayposer.util.BlockStateUtils;
import net.sixunderscore.blockdisplayposer.utils.Utils;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BlockDisplayPoserScreen
extends class_437 {
    private final int blockDisplayEntityId;
    private final Vector3f entityPos;
    private final Quaternionf entityRotation;
    private final Vector3f entityScale;
    private final String blockTypeStr;
    private final String blockStateAttributesStr;
    private final int blockBrightness;
    private final int skyBrightness;
    private final float viewDistance;
    private final List<NumericFieldWidget> allFields = new ArrayList<NumericFieldWidget>(12);
    private NumericFieldWidget xPosField;
    private NumericFieldWidget yPosField;
    private NumericFieldWidget zPosField;
    private NumericFieldWidget pitchField;
    private NumericFieldWidget yawField;
    private NumericFieldWidget rollField;
    private ScaleFieldWidget xScaleField;
    private ScaleFieldWidget yScaleField;
    private ScaleFieldWidget zScaleField;
    private NumericFieldWidget skyBrightnessField;
    private NumericFieldWidget blockBrightnessField;
    private NumericFieldWidget viewDistanceField;
    private static final BigDecimal[] KEY_SCALAR_FACTORS = new BigDecimal[]{new BigDecimal("0.1"), new BigDecimal("0.0625"), BigDecimal.ONE};
    private int scalarFactorIndex = 0;

    public BlockDisplayPoserScreen(int blockDisplayEntityId, Vector3f position, Quaternionf rotation, Vector3f scale, class_2680 blockState, int blockBrightness, int skyBrightness, float viewDistance) {
        super((class_2561)class_2561.method_43470((String)"BlockDisplayPoserScreen"));
        this.blockDisplayEntityId = blockDisplayEntityId;
        this.entityPos = position;
        this.entityRotation = rotation;
        this.entityScale = scale;
        String[] blockStateParts = BlockStateUtils.separateBlockStateParts(blockState);
        this.blockTypeStr = blockStateParts[0];
        this.blockStateAttributesStr = blockStateParts[1];
        this.blockBrightness = blockBrightness;
        this.skyBrightness = skyBrightness;
        this.viewDistance = viewDistance;
    }

    protected void method_25426() {
        this.createTextWidget(this.field_22789 / 2 - 50, 5, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.title"));
        this.createTextWidget(this.field_22789 - 180, 25, 10, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.x"));
        this.createTextWidget(this.field_22789 - 115, 25, 10, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.y"));
        this.createTextWidget(this.field_22789 - 50, 25, 10, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.z"));
        this.createTextWidget(this.field_22789 - 280, 40, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.position"));
        this.xPosField = this.createNumericFieldWidget(this.field_22789 - 200, 35, 60, 20, Utils.formatNum(this.entityPos.x));
        this.yPosField = this.createNumericFieldWidget(this.field_22789 - 135, 35, 60, 20, Utils.formatNum(this.entityPos.y));
        this.zPosField = this.createNumericFieldWidget(this.field_22789 - 70, 35, 60, 20, Utils.formatNum(this.entityPos.z));
        this.createTextWidget(this.field_22789 - 330, 65, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.axisscale"));
        this.xScaleField = this.createScaleFieldWidget(this.field_22789 - 200, 60, 60, 20, Utils.formatNum(this.entityScale.x));
        this.yScaleField = this.createScaleFieldWidget(this.field_22789 - 135, 60, 60, 20, Utils.formatNum(this.entityScale.y));
        this.zScaleField = this.createScaleFieldWidget(this.field_22789 - 70, 60, 60, 20, Utils.formatNum(this.entityScale.z));
        this.createButtonWidget(this.field_22789 - 250, 60, 20, 20, (class_2561)class_2561.method_43470((String)"\u2191"), button -> {
            this.modifyTextFieldValue(this.xScaleField, false);
            this.modifyTextFieldValue(this.yScaleField, false);
            this.modifyTextFieldValue(this.zScaleField, false);
        });
        this.createButtonWidget(this.field_22789 - 225, 60, 20, 20, (class_2561)class_2561.method_43470((String)"\u2193"), button -> {
            this.modifyTextFieldValue(this.xScaleField, true);
            this.modifyTextFieldValue(this.yScaleField, true);
            this.modifyTextFieldValue(this.zScaleField, true);
        });
        this.createTextWidget(this.field_22789 - 280, 100, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.rotation"));
        this.createTextWidget(this.field_22789 - 195, 85, 50, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.pitch"));
        this.createTextWidget(this.field_22789 - 130, 85, 50, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.yaw"));
        this.createTextWidget(this.field_22789 - 65, 85, 50, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.roll"));
        Vector3f rotation = Utils.quaternionToEuler(this.entityRotation);
        this.pitchField = this.createNumericFieldWidget(this.field_22789 - 200, 95, 60, 20, Utils.formatNum(rotation.x));
        this.yawField = this.createNumericFieldWidget(this.field_22789 - 135, 95, 60, 20, Utils.formatNum(rotation.y));
        this.rollField = this.createNumericFieldWidget(this.field_22789 - 70, 95, 60, 20, Utils.formatNum(rotation.z));
        this.createTextWidget(this.field_22789 - 280, 125, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.blocktype"));
        class_342 blockTypeField = this.createTextFieldWidget(this.field_22789 - 200, 120, 190, 20, this.blockTypeStr);
        this.createTextWidget(this.field_22789 - 290, 155, 100, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.blockattributes"));
        class_342 blockAttributesField = this.createTextFieldWidget(this.field_22789 - 200, 150, 190, 20, this.blockStateAttributesStr);
        this.createTextWidget(5, 40, 60, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.brightness"));
        this.createTextWidget(75, 25, 50, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.skybrightness"));
        this.skyBrightnessField = this.createNumericFieldWidget(75, 35, 60, 20, Utils.formatNum(this.skyBrightness));
        this.createTextWidget(140, 25, 50, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.blockbrightness"));
        this.blockBrightnessField = this.createNumericFieldWidget(140, 35, 60, 20, Utils.formatNum(this.blockBrightness));
        this.createTextWidget(5, 70, 70, 10, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.viewdistance"));
        this.viewDistanceField = this.createNumericFieldWidget(75, 65, 60, 20, Utils.formatNum(this.viewDistance));
        this.createButtonWidget(10, this.field_22790 - 30, 130, 20, (class_2561)class_2561.method_43469((String)"screen.blockdisplay.keyscale", (Object[])new Object[]{KEY_SCALAR_FACTORS[this.scalarFactorIndex]}), button -> {
            ++this.scalarFactorIndex;
            this.scalarFactorIndex %= KEY_SCALAR_FACTORS.length;
            button.method_25355((class_2561)class_2561.method_43469((String)"screen.blockdisplay.keyscale", (Object[])new Object[]{KEY_SCALAR_FACTORS[this.scalarFactorIndex]}));
        });
        this.createButtonWidget(this.field_22789 / 2 - 85, this.field_22790 - 30, 170, 20, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.done"), button -> {
            ClientPlayNetworking.send((class_8710)new SendDisplayBlockStatePayload(this.blockDisplayEntityId, BlockStateUtils.parseBlockState(blockTypeField.method_1882() + blockAttributesField.method_1882())));
            this.method_25419();
        });
        this.createButtonWidget(this.field_22789 - 105, this.field_22790 - 105, 100, 20, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.center"), button -> this.center());
        this.createButtonWidget(this.field_22789 - 105, this.field_22790 - 80, 100, 20, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.undo"), button -> {
            this.undoChanges();
            this.method_25419();
        });
        this.createButtonWidget(this.field_22789 - 105, this.field_22790 - 55, 100, 20, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.clone"), button -> {
            ClientPlayNetworking.send((class_8710)new CloneDisplayPayload(this.blockDisplayEntityId));
            this.method_25419();
        });
        this.createButtonWidget(this.field_22789 - 105, this.field_22790 - 30, 100, 20, (class_2561)class_2561.method_43471((String)"screen.blockdisplay.delete"), button -> {
            ClientPlayNetworking.send((class_8710)new DeleteDisplayPayload(this.blockDisplayEntityId));
            this.method_25419();
        });
    }

    private NumericFieldWidget createNumericFieldWidget(int x, int y, int width, int height, String text) {
        NumericFieldWidget field = new NumericFieldWidget(this.method_64506(), x, y, width, height, (class_2561)class_2561.method_43473());
        field.method_1852(text);
        field.method_1863(str -> this.updateBlockAttributes());
        this.allFields.add(field);
        this.method_37063((class_364)field);
        return field;
    }

    private ScaleFieldWidget createScaleFieldWidget(int x, int y, int width, int height, String text) {
        ScaleFieldWidget field = new ScaleFieldWidget(this.method_64506(), x, y, width, height, (class_2561)class_2561.method_43473());
        field.method_1852(text);
        field.method_1863(str -> this.updateBlockAttributes());
        this.allFields.add(field);
        this.method_37063((class_364)field);
        return field;
    }

    private class_342 createTextFieldWidget(int x, int y, int width, int height, String text) {
        class_342 field = new class_342(this.method_64506(), x, y, width, height, (class_2561)class_2561.method_43473());
        field.method_1880(Integer.MAX_VALUE);
        field.method_1852(text);
        field.method_1870(false);
        this.method_37063((class_364)field);
        return field;
    }

    private void createTextWidget(int x, int y, int width, int height, class_2561 text) {
        this.method_37063((class_364)new class_7842(x, y, width, height, text, this.method_64506()));
    }

    private void createButtonWidget(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 pressAction) {
        class_4185 button = class_4185.method_46430((class_2561)text, (class_4185.class_4241)pressAction).method_46434(x, y, width, height).method_46431();
        this.method_37063((class_364)button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (NumericFieldWidget field : this.allFields) {
            if (!field.method_25367()) continue;
            return switch (keyCode) {
                case 265 -> this.modifyTextFieldValue(field, false);
                case 264 -> this.modifyTextFieldValue(field, true);
                default -> super.method_25404(keyCode, scanCode, modifiers);
            };
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean modifyTextFieldValue(NumericFieldWidget field, boolean subtract) {
        BigDecimal textFieldValue = Utils.safeParseBigDecimal(field.method_1882());
        BigDecimal keyScalarFactor = KEY_SCALAR_FACTORS[this.scalarFactorIndex];
        BigDecimal newValue = ((Object)((Object)field)).equals((Object)this.blockBrightnessField) || ((Object)((Object)field)).equals((Object)this.skyBrightnessField) ? (subtract ? textFieldValue.subtract(BigDecimal.ONE) : textFieldValue.add(BigDecimal.ONE)) : (subtract ? textFieldValue.subtract(keyScalarFactor) : textFieldValue.add(keyScalarFactor));
        String newValueStr = Utils.formatNum(newValue.toString());
        if (field instanceof ScaleFieldWidget) {
            ScaleFieldWidget scaleField = (ScaleFieldWidget)field;
            scaleField.setText(newValueStr, keyScalarFactor);
        } else {
            field.method_1852(newValueStr);
        }
        return true;
    }

    private void center() {
        BigDecimal xDelta = this.xScaleField.getCumulativeDelta();
        BigDecimal yDelta = this.yScaleField.getCumulativeDelta();
        BigDecimal zDelta = this.zScaleField.getCumulativeDelta();
        this.xPosField.method_1852(this.centerPos(this.xPosField.method_1882(), xDelta));
        this.yPosField.method_1852(this.centerPos(this.yPosField.method_1882(), yDelta));
        this.zPosField.method_1852(this.centerPos(this.zPosField.method_1882(), zDelta));
    }

    private String centerPos(String posStr, BigDecimal scaleDelta) {
        try {
            BigDecimal deltaHalved = scaleDelta.divide(BigDecimal.TWO, 4, RoundingMode.HALF_UP);
            BigDecimal posValue = new BigDecimal(posStr);
            return Utils.formatNum(posValue.subtract(deltaHalved).toString());
        }
        catch (NumberFormatException e) {
            return posStr;
        }
    }

    public void updateBlockAttributes() {
        Vector3f newPos = new Vector3f(Utils.safeParseFloat(this.xPosField.method_1882()), Utils.safeParseFloat(this.yPosField.method_1882()), Utils.safeParseFloat(this.zPosField.method_1882()));
        Quaternionf newRotation = new Quaternionf().rotationXYZ((float)Math.toRadians(Utils.safeParseFloat(this.pitchField.method_1882())), (float)Math.toRadians(Utils.safeParseFloat(this.yawField.method_1882())), (float)Math.toRadians(Utils.safeParseFloat(this.rollField.method_1882())));
        Vector3f newScale = new Vector3f(Utils.safeParseFloat(this.xScaleField.method_1882()), Utils.safeParseFloat(this.yScaleField.method_1882()), Utils.safeParseFloat(this.zScaleField.method_1882()));
        ClientPlayNetworking.send((class_8710)new SendDisplayNumericDataPayload(this.blockDisplayEntityId, newPos, newRotation, newScale, Utils.safeParseInt(this.blockBrightnessField.method_1882()), Utils.safeParseInt(this.skyBrightnessField.method_1882()), Utils.safeParseFloat(this.viewDistanceField.method_1882())));
    }

    private void undoChanges() {
        ClientPlayNetworking.send((class_8710)new SendDisplayNumericDataPayload(this.blockDisplayEntityId, this.entityPos, this.entityRotation, this.entityScale, this.blockBrightness, this.skyBrightness, this.viewDistance));
    }

    public boolean method_25421() {
        return false;
    }
}

