/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.blockdisplayposer.screen;

import java.math.BigDecimal;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.sixunderscore.blockdisplayposer.screen.NumericFieldWidget;
import net.sixunderscore.blockdisplayposer.utils.Utils;

@Environment(value=EnvType.CLIENT)
public class ScaleFieldWidget
extends NumericFieldWidget {
    public static final BigDecimal defaultMin = new BigDecimal("0.0625");
    public static final BigDecimal defaultMax = new BigDecimal("16");
    private BigDecimal cumulativeDelta = BigDecimal.ZERO;
    private boolean isInitialized = false;

    public ScaleFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        super(textRenderer, x, y, width, height, text);
    }

    @Override
    public void method_1867(String text) {
        super.method_1867(text);
        this.validateBounds(defaultMin, defaultMax);
        this.storeDelta();
    }

    public void setText(String text, BigDecimal minBound) {
        super.method_1852(text);
        this.validateBounds(minBound, defaultMax);
        this.storeDelta();
    }

    @Override
    public void method_1852(String text) {
        super.method_1852(text);
        this.validateBounds(defaultMin, defaultMax);
        this.storeDelta();
    }

    @Override
    public void method_1878(int characterOffset) {
        super.method_1878(characterOffset);
        this.validateBounds(defaultMin, defaultMax);
        this.storeDelta();
    }

    @Override
    public void method_55506(int position) {
        super.method_55506(position);
        this.validateBounds(defaultMin, defaultMax);
        this.storeDelta();
    }

    private void validateBounds(BigDecimal minBound, BigDecimal maxBound) {
        BigDecimal newValue = Utils.safeParseBigDecimal(this.method_1882());
        if (newValue.compareTo(minBound) < 0) {
            super.method_1852(Utils.formatNum(minBound.toString()));
        } else if (newValue.compareTo(maxBound) > 0) {
            super.method_1852(Utils.formatNum(maxBound.toString()));
        }
    }

    private void storeDelta() {
        if (this.isInitialized) {
            BigDecimal currentValue = Utils.safeParseBigDecimal(this.method_1882());
            BigDecimal prevValue = Utils.safeParseBigDecimal(this.prevText);
            BigDecimal currentDelta = currentValue.subtract(prevValue);
            this.cumulativeDelta = this.cumulativeDelta.add(currentDelta);
        } else {
            this.isInitialized = true;
        }
    }

    public BigDecimal getCumulativeDelta() {
        BigDecimal result = this.cumulativeDelta;
        this.cumulativeDelta = BigDecimal.ZERO;
        return result;
    }
}

