/*
 * Decompiled with CFR 0.152.
 */
package net.sixunderscore.blockdisplayposer.utils;

import java.math.BigDecimal;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Utils {
    public static Vector3f quaternionToEuler(Quaternionf rotation) {
        Vector3f rotationVec = rotation.getEulerAnglesXYZ(new Vector3f());
        rotationVec.x = (float)Math.toDegrees(rotationVec.x);
        rotationVec.y = (float)Math.toDegrees(rotationVec.y);
        rotationVec.z = (float)Math.toDegrees(rotationVec.z);
        return rotationVec;
    }

    public static String formatNum(float num) {
        return Utils.formatNum(String.format("%.4f", Float.valueOf(num)));
    }

    public static String formatNum(String str) {
        int cursor;
        for (cursor = str.length() - 1; cursor >= 0 && str.charAt(cursor) == '0'; --cursor) {
        }
        if (cursor >= 0 && str.charAt(cursor) == '.') {
            --cursor;
        }
        return str.substring(0, cursor + 1);
    }

    public static float safeParseFloat(String str) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int safeParseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static BigDecimal safeParseBigDecimal(String str) {
        try {
            return str.trim().isEmpty() ? BigDecimal.ZERO : new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }
}

