/*
 * Decompiled with CFR 0.152.
 */
package net.mobilelize.hold_that_chunk.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2666;
import net.minecraft.class_310;
import net.mobilelize.hold_that_chunk.client.config.ConfigManager;

@Environment(value=EnvType.CLIENT)
public class ChunkUnloader {
    private final Set<class_1923> pendingUnloads = ConcurrentHashMap.newKeySet();
    private final Set<class_1923> processedUnloads = new HashSet<class_1923>();
    private int originalServerRenderDistance = 128;

    public ChunkUnloader() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.processUnloads());
    }

    public void setOriginalServerRenderDistance(int originalServerRenderDistance) {
        this.originalServerRenderDistance = originalServerRenderDistance;
    }

    public int getOriginalServerRenderDistance() {
        return this.originalServerRenderDistance;
    }

    public void onUnloadPacket(class_2666 packet) {
        class_310.method_1551().execute(() -> this.pendingUnloads.add(packet.comp_1726()));
    }

    public void processUnloads() {
        if (this.pendingUnloads.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || client.field_1724 == null) {
            return;
        }
        class_1923 playerPos = client.field_1724.method_31476();
        Iterator<class_1923> it = this.pendingUnloads.iterator();
        while (it.hasNext()) {
            class_1923 pos = it.next();
            boolean isOutsideDistance = pos.method_24022(playerPos) > this.getHoldDistance();
            boolean respectServerDistance = ConfigManager.configData.respectServerDistance;
            boolean modEnabled = ConfigManager.configData.holdThatChunkEnabled;
            if (modEnabled && !isOutsideDistance && !respectServerDistance) continue;
            this.processedUnloads.add(pos);
            client.method_1562().method_11107(new class_2666(pos));
            it.remove();
        }
    }

    public boolean isBeingProcessedRemove(class_1923 pos) {
        if (this.processedUnloads.contains(pos)) {
            this.processedUnloads.remove(pos);
            return true;
        }
        return false;
    }

    private int getHoldDistance() {
        if (ConfigManager.configData.linkRenderDistance) {
            return (Integer)class_310.method_1551().field_1690.method_42503().method_41753();
        }
        return ConfigManager.configData.holdDistance;
    }

    public void clear() {
        this.pendingUnloads.clear();
        this.processedUnloads.clear();
    }

    public void removePending(class_1923 pos) {
        this.pendingUnloads.remove(pos);
        this.processedUnloads.remove(pos);
    }
}

