/*
 * Decompiled with CFR 0.152.
 */
package net.mobilelize.hold_that_chunk.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.mobilelize.hold_that_chunk.client.Hold_that_chunkClient;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File(class_310.method_1551().field_1697, "config/HoldThatChunk_V2");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "hold_that_chunk.json");
    public static ConfigData configData = new ConfigData();

    public static void loadConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                ConfigManager.saveDefaultConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);){
                configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
        }
        catch (Exception e) {
            Hold_that_chunkClient.logger.error("Failed to load config: {}", (Object)e.getMessage());
        }
    }

    public static void saveConfig() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                GSON.toJson((Object)configData, (Appendable)writer);
            }
        }
        catch (Exception e) {
            Hold_that_chunkClient.logger.error("[HoldThatChunk] Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static void saveDefaultConfig() {
        ConfigManager.saveConfig();
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigData {
        public boolean respectServerDistance = false;
        public boolean linkRenderDistance = false;
        public boolean holdThatChunkEnabled = true;
        public boolean ignoreServerDistance = true;
        public int holdDistance = 64;
    }
}

