/*
 * Decompiled with CFR 0.152.
 */
package net.mobilelize.hold_that_chunk.client;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2666;
import net.minecraft.class_2672;
import net.minecraft.class_310;
import net.minecraft.class_631;
import net.mobilelize.hold_that_chunk.client.config.ConfigManager;

@Environment(value=EnvType.CLIENT)
public class ChunkUnloader {
    private final Set<class_1923> pendingUnloads = ConcurrentHashMap.newKeySet();
    private final Set<class_1923> processedUnloads = ConcurrentHashMap.newKeySet();
    private final Map<class_1923, class_2672> clearedChunks = new ConcurrentHashMap<class_1923, class_2672>();
    private final Set<class_1923> processedClears = ConcurrentHashMap.newKeySet();
    private int originalServerRenderDistance = 128;

    public ChunkUnloader() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.processUnloads());
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.processEmptyLoads());
    }

    public void setOriginalServerRenderDistance(int originalServerRenderDistance) {
        this.originalServerRenderDistance = originalServerRenderDistance;
    }

    public int getOriginalServerRenderDistance() {
        return this.originalServerRenderDistance;
    }

    public void markCleared(class_1923 pos, class_2672 packet) {
        class_310.method_1551().execute(() -> this.clearedChunks.put(pos, packet));
    }

    public void unmarkCleared(class_1923 pos) {
        this.clearedChunks.remove(pos);
    }

    public boolean shouldCancelEmptyChunk(class_1923 pos) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return false;
        }
        if (!ConfigManager.configData.cancelEmptyChunks) {
            return false;
        }
        if (!ConfigManager.configData.holdThatChunkEnabled) {
            return false;
        }
        if (ConfigManager.configData.respectServerDistance) {
            return false;
        }
        if (!this.isChunkLoaded(pos)) {
            return false;
        }
        if (this.closeToEmptyChunk(pos)) {
            return false;
        }
        return this.farEnoughFromEmptyChunk(pos);
    }

    public boolean closeToEmptyChunk(class_1923 pos) {
        int prox;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return true;
        }
        int dist = pos.method_24022(client.field_1724.method_31476());
        return dist <= (prox = Math.max(2, ConfigManager.configData.restoreEmptyChunksDistance));
    }

    public boolean farEnoughFromEmptyChunk(class_1923 pos) {
        int prox;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return true;
        }
        int dist = pos.method_24022(client.field_1724.method_31476());
        return dist >= (prox = Math.min(256, ConfigManager.configData.ignoreEmptyChunksDistance));
    }

    private boolean isChunkLoaded(class_1923 pos) {
        class_310 client = class_310.method_1551();
        assert (client.field_1687 != null);
        class_631 cm = client.field_1687.method_2935();
        return cm != null && cm.method_12123(pos.field_9181, pos.field_9180);
    }

    public void onUnloadPacket(class_2666 packet) {
        class_310.method_1551().execute(() -> this.pendingUnloads.add(packet.comp_1726()));
    }

    public void processUnloads() {
        if (this.pendingUnloads.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || client.field_1724 == null) {
            return;
        }
        class_1923 playerPos = client.field_1724.method_31476();
        Iterator<class_1923> it = this.pendingUnloads.iterator();
        while (it.hasNext()) {
            class_1923 pos = it.next();
            boolean isOutsideDistance = pos.method_24022(playerPos) > this.getHoldDistance();
            boolean respectServerDistance = ConfigManager.configData.respectServerDistance;
            boolean modEnabled = ConfigManager.configData.holdThatChunkEnabled;
            if (modEnabled && !isOutsideDistance && !respectServerDistance) continue;
            this.processedUnloads.add(pos);
            client.method_1562().method_11107(new class_2666(pos));
            it.remove();
        }
    }

    public void processEmptyLoads() {
        if (this.clearedChunks.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        Iterator<Map.Entry<class_1923, class_2672>> it = this.clearedChunks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_1923, class_2672> empty = it.next();
            boolean emptyChunks = ConfigManager.configData.cancelEmptyChunks;
            boolean modEnabled = ConfigManager.configData.holdThatChunkEnabled;
            if (modEnabled && emptyChunks && !this.closeToEmptyChunk(empty.getKey())) continue;
            this.processedClears.add(empty.getKey());
            client.method_1562().method_11128(empty.getValue());
            it.remove();
        }
    }

    public void loadEmpty(class_1923 pos) {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            if (client.method_1562() == null || client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            if (this.clearedChunks.containsKey(pos)) {
                class_2672 remove = this.clearedChunks.remove(pos);
                this.processedClears.add(pos);
                client.method_1562().method_11128(remove);
            }
        });
    }

    public boolean isBeingProcessedRemove(class_1923 pos) {
        if (this.processedUnloads.contains(pos)) {
            this.processedUnloads.remove(pos);
            return true;
        }
        return false;
    }

    public boolean isEmptyBeingProcessedRemove(class_1923 pos) {
        if (this.processedClears.contains(pos)) {
            this.processedClears.remove(pos);
            return true;
        }
        return false;
    }

    private int getHoldDistance() {
        if (ConfigManager.configData.linkRenderDistance) {
            return (Integer)class_310.method_1551().field_1690.method_42503().method_41753();
        }
        return ConfigManager.configData.holdDistance;
    }

    public void clear() {
        this.pendingUnloads.clear();
        this.processedUnloads.clear();
        this.clearedChunks.clear();
        this.processedClears.clear();
    }

    public void removePending(class_1923 pos) {
        this.pendingUnloads.remove(pos);
        this.processedUnloads.remove(pos);
    }
}

