/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.mixin.serverbrowser;

import com.epherical.serverbrowser.client.list.ServerBrowserList;
import com.google.gson.JsonElement;
import java.util.List;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={ServerBrowserList.class})
public class ServerBrowserListMixin {
    @Shadow(remap=false)
    @Final
    private List<ServerBrowserList.BrowsedEntry> entries;

    @Unique
    private static void servercountryflags$updateLocationInfos(List<ServerBrowserList.BrowsedEntry> entries) {
        entries.forEach(entry -> {
            String ip = entry.getServerData().ip;
            if (!ServerCountryFlags.servers.containsKey(ip) || ServerCountryFlags.servers.get(ip).status() != APIResponse.Status.SUCCESS) {
                ServerCountryFlags.updateServerLocationInfo(ip);
            }
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"refreshServers"}, remap=false)
    public void refreshServers(CallbackInfo ci) {
        if (!Config.cfg.serverBrowserIntegration) {
            return;
        }
        if (Config.cfg.reloadOnRefresh) {
            ServerCountryFlags.servers.entrySet().removeIf(entry -> this.entries.stream().anyMatch(browsedEntry -> browsedEntry.getServerData().ip.equals(entry.getKey())));
        }
        ServerBrowserListMixin.servercountryflags$updateLocationInfos(this.entries);
    }

    @Inject(at={@At(value="TAIL")}, method={"addEntries"}, remap=false)
    public void addEntries(JsonElement jsonElement, boolean toTop, CallbackInfo ci) {
        if (!Config.cfg.serverBrowserIntegration) {
            return;
        }
        ServerBrowserListMixin.servercountryflags$updateLocationInfos(this.entries);
    }
}

