/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import me.khajiitos.servercountryflags.common.util.LocationInfo;
import me.khajiitos.servercountryflags.common.util.NetworkChangeDetector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ServerMapScreen
extends Screen {
    public static final ResourceLocation MAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"servercountryflags", (String)"textures/gui/misc/map.png");
    public static final ResourceLocation POINT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"servercountryflags", (String)"textures/gui/misc/point.png");
    public static final ResourceLocation POINT_HOVERED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"servercountryflags", (String)"textures/gui/misc/point_hovered.png");
    public static final ResourceLocation POINT_HOME_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"servercountryflags", (String)"textures/gui/misc/point_home.png");
    public static final double MAP_TEXTURE_ASPECT = 2.0;
    public static final double POINT_TEXTURE_ASPECT = 0.6976127320954907;
    public static final double ZOOM_STRENGTH = 0.1;
    private int mapStartX;
    private int mapStartY;
    private int mapWidth;
    private int mapHeight;
    private final Screen parent;
    private final ArrayList<Point> points = new ArrayList();
    private double zoomedAreaStartX = 0.0;
    private double zoomedAreaStartY = 0.0;
    private double zoomedAreaWidth = 1.0;
    private double zoomedAreaHeight = 1.0;
    private boolean movingMap = false;
    private double movingMapLastX = -1.0;
    private double movingMapLastY = -1.0;

    public ServerMapScreen(Screen parent) {
        super((Component)Component.translatable((String)"servercountryflags.servermap.title"));
        this.parent = parent;
        if (Config.cfg.showHomeOnMap && ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    public Point getPoint(double lon, double lat) {
        for (Point point : this.points) {
            if (point.locationInfo.longitude != lon || point.locationInfo.latitude != lat) continue;
            return point;
        }
        return null;
    }

    public double clampDouble(double value, double min, double max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        if (this.movingMap) {
            double deltaX = (this.movingMapLastX - mouseX) / (double)this.mapWidth * this.zoomedAreaWidth;
            double deltaY = (this.movingMapLastY - mouseY) / (double)this.mapHeight * this.zoomedAreaHeight;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + deltaX, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + deltaY, 0.0, 1.0 - this.zoomedAreaHeight);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.movingMap = false;
            this.movingMapLastX = -1.0;
            this.movingMapLastY = -1.0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            this.movingMap = true;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            double oldWidth = this.zoomedAreaWidth;
            double oldHeight = this.zoomedAreaHeight;
            this.zoomedAreaWidth = this.clampDouble(this.zoomedAreaWidth - amountY * 0.1, 0.05, 1.0);
            this.zoomedAreaHeight = this.clampDouble(this.zoomedAreaHeight - amountY * 0.1, 0.05, 1.0);
            double widthDelta = oldWidth - this.zoomedAreaWidth;
            double heightDelta = oldHeight - this.zoomedAreaHeight;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + (mouseX - (double)this.mapStartX) / (double)this.mapWidth * widthDelta, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + (mouseY - (double)this.mapStartY) / (double)this.mapHeight * heightDelta, 0.0, 1.0 - this.zoomedAreaHeight);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    private void addPoint(String name, LocationInfo locationInfo) {
        Point point = this.getPoint(locationInfo.longitude, locationInfo.latitude);
        if (point != null) {
            point.addServer(name);
        } else {
            this.points.add(new Point(name, locationInfo));
        }
    }

    public void init() {
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"selectServer.refresh"), button -> {
            this.clearWidgets();
            this.init();
            if (ServerCountryFlags.serverList == null) {
                return;
            }
            if (Config.cfg.reloadOnRefresh) {
                this.points.clear();
                ServerCountryFlags.servers.clear();
                ServerCountryFlags.localLocation = null;
            }
            if (ServerCountryFlags.localLocation == null || NetworkChangeDetector.check()) {
                ServerCountryFlags.updateLocalLocationInfo();
            }
            for (int i = 0; i < ServerCountryFlags.serverList.size(); ++i) {
                if (ServerCountryFlags.servers.containsKey(ServerCountryFlags.serverList.get((int)i).ip)) continue;
                ServerCountryFlags.updateServerLocationInfo(ServerCountryFlags.serverList.get((int)i).ip);
            }
        }).bounds(this.width / 2 - 105, this.height - 26, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.back"), button -> Minecraft.getInstance().setScreen(this.parent)).bounds(this.width / 2 + 5, this.height - 26, 100, 20).build());
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.getTitle().getVisualOrderText(), this.width / 2, 12, -1);
        context.fill(0, 32, this.width, this.height - 32, -1442840576);
        this.mapHeight = this.height - 64;
        this.mapWidth = (int)((double)this.mapHeight * 2.0);
        if (this.mapWidth > this.width) {
            this.mapWidth = this.width;
            this.mapHeight = (int)((double)this.mapWidth / 2.0);
        }
        this.mapStartX = this.width / 2 - this.mapWidth / 2;
        this.mapStartY = 32 + ((this.height - 64) / 2 - this.mapHeight / 2);
        context.blit(RenderPipelines.GUI_TEXTURED, MAP_TEXTURE, this.mapStartX, this.mapStartY, (float)((double)this.mapWidth * this.zoomedAreaStartX), (float)((double)this.mapHeight * this.zoomedAreaStartY), this.mapWidth, this.mapHeight, (int)((double)this.mapWidth * this.zoomedAreaWidth), (int)((double)this.mapHeight * this.zoomedAreaHeight), this.mapWidth, this.mapHeight);
        Point hoveredPoint = null;
        int pointHeight = this.mapHeight / 20;
        int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
        if (mouseX >= this.mapStartX && mouseX <= this.mapStartX + this.mapWidth && mouseY >= this.mapStartY && mouseY <= this.mapStartY + this.mapHeight) {
            for (int i = this.points.size() - 1; i >= 0; --i) {
                Point point = this.points.get(i);
                Coordinates coords = this.latlonToPos(point.locationInfo.latitude, point.locationInfo.longitude, this.mapWidth, this.mapHeight);
                double pointStartX = (double)this.mapStartX + coords.x - (double)pointWidth / 2.0;
                double pointStartY = (double)this.mapStartY + coords.y - (double)pointHeight;
                if (!((double)mouseX >= pointStartX) || !((double)mouseX <= pointStartX + (double)pointWidth) || !((double)mouseY >= pointStartY) || !((double)mouseY <= pointStartY + (double)pointHeight)) continue;
                hoveredPoint = point;
                break;
            }
        }
        for (Point point : this.points) {
            point.render(context, hoveredPoint == point);
        }
        if (hoveredPoint != null) {
            context.setTooltipForNextFrame(hoveredPoint.getTooltip(), mouseX, mouseY);
        }
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private static boolean doesServerListHaveServer(String serverIp) {
        if (ServerCountryFlags.serverList == null) {
            return false;
        }
        return ServerCountryFlags.serverList.get(serverIp) != null;
    }

    public void tick() {
        super.tick();
        this.points.clear();
        if (Config.cfg.showHomeOnMap && ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (!ServerMapScreen.doesServerListHaveServer(entry.getKey()) || entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    private Coordinates latlonToPos(double lat, double lon, int width, int height) {
        double x = (double)width * (((180.0 + lon) / 360.0 - this.zoomedAreaStartX) / this.zoomedAreaHeight);
        double y = (double)height * (((90.0 - lat) / 180.0 - this.zoomedAreaStartY) / this.zoomedAreaWidth);
        return new Coordinates(x, y);
    }

    public class Point {
        LocationInfo locationInfo;
        List<String> servers = new ArrayList<String>();
        public boolean hasHome;

        public Point(String beginningName, LocationInfo beginningLocationInfo) {
            this.locationInfo = beginningLocationInfo;
            this.addServer(beginningName);
        }

        public void addServer(String name) {
            if (name == null) {
                this.hasHome = true;
            }
            this.servers.add(name);
        }

        public List<FormattedCharSequence> getTooltip() {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.literal((String)((String)(Config.cfg.showDistrict && !this.locationInfo.districtName.isEmpty() ? this.locationInfo.districtName + ", " : "") + this.locationInfo.cityName + ", " + this.locationInfo.countryName)).withStyle(ChatFormatting.BOLD).getVisualOrderText());
            list.add(Component.nullToEmpty(null).getVisualOrderText());
            for (String server : this.servers) {
                if (server == null) {
                    list.add(Component.translatable((String)"servercountryflags.servermap.home").withStyle(ChatFormatting.BOLD).getVisualOrderText());
                    continue;
                }
                list.add(Component.literal((String)server).getVisualOrderText());
            }
            return list;
        }

        private void render(GuiGraphics context, boolean hovered) {
            Coordinates coords = ServerMapScreen.this.latlonToPos(this.locationInfo.latitude, this.locationInfo.longitude, ServerMapScreen.this.mapWidth, ServerMapScreen.this.mapHeight);
            int pointHeight = ServerMapScreen.this.mapHeight / 20;
            int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
            double pointStartX = (double)ServerMapScreen.this.mapStartX + coords.x - (double)pointWidth / 2.0;
            double pointStartY = (double)ServerMapScreen.this.mapStartY + coords.y - (double)pointHeight;
            if (coords.x < -((double)pointWidth / 2.0) || coords.x > (double)ServerMapScreen.this.mapWidth + (double)pointWidth / 2.0 || coords.y < 0.0 || coords.y > (double)(ServerMapScreen.this.mapHeight + pointHeight)) {
                return;
            }
            ResourceLocation texture = POINT_TEXTURE;
            if (this.hasHome) {
                texture = POINT_HOME_TEXTURE;
            } else if (hovered) {
                texture = POINT_HOVERED_TEXTURE;
            }
            context.enableScissor(ServerMapScreen.this.mapStartX, ServerMapScreen.this.mapStartY, ServerMapScreen.this.mapStartX + ServerMapScreen.this.mapWidth, ServerMapScreen.this.mapStartY + ServerMapScreen.this.mapHeight);
            context.pose().pushMatrix();
            context.pose().translate((float)pointStartX, (float)pointStartY);
            context.blit(RenderPipelines.GUI_TEXTURED, texture, 0, 0, 0.0f, 0.0f, pointWidth, pointHeight, pointWidth, pointHeight);
            context.pose().popMatrix();
            context.disableScissor();
        }
    }

    public static class Coordinates {
        public double x;
        public double y;

        public Coordinates(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

