/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Color {
    private static final Pattern SAVE_PATTERN = Pattern.compile("\\((\\d+), (\\d+), (\\d+), (\\d+)\\)");
    public int r;
    public int g;
    public int b;
    public int a;

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public String toString() {
        return String.format("(%d, %d, %d, %d)", this.r, this.g, this.b, this.a);
    }

    public static Color fromString(String string) {
        Matcher matcher = SAVE_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                int r = Integer.parseInt(matcher.group(1));
                int g = Integer.parseInt(matcher.group(2));
                int b = Integer.parseInt(matcher.group(3));
                int a = Integer.parseInt(matcher.group(4));
                return new Color(r, g, b, a < 0 ? 127 - a : a);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Color(255, 255, 255, 255);
    }

    public static Color fromARGB(int argb) {
        int r = (argb & 0xFF0000) >> 16;
        int g = (argb & 0xFF00) >> 8;
        int b = argb & 0xFF;
        int a = argb >> 24 & 0xFF;
        return new Color(r, g, b, a);
    }

    public int toARGB() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }
}

