/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.client.listeners;

import cc.pe3epwithyou.trident.client.events.KillEvents;
import cc.pe3epwithyou.trident.config.Config;
import cc.pe3epwithyou.trident.feature.killfeed.DeathMessages;
import cc.pe3epwithyou.trident.feature.killfeed.KillMethod;
import cc.pe3epwithyou.trident.feature.questing.EliminatedCriteria;
import cc.pe3epwithyou.trident.feature.questing.IncrementContext;
import cc.pe3epwithyou.trident.feature.questing.QuestCriteria;
import cc.pe3epwithyou.trident.feature.questing.QuestStorage;
import cc.pe3epwithyou.trident.interfaces.killfeed.KillFeedDialog;
import cc.pe3epwithyou.trident.interfaces.killfeed.widgets.KillWidget;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.state.MCCIState;
import com.noxcrew.sheeplib.util.IntColorUtilKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_5520;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR3\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00110\u001fj\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0011`!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcc/pe3epwithyou/trident/client/listeners/KillChatListener;", "", "<init>", "()V", "", "resetStreaks", "register", "Lnet/minecraft/class_2561;", "message", "Lcc/pe3epwithyou/trident/feature/killfeed/KillMethod;", "method", "", "handleKill", "(Lnet/minecraft/class_2561;Lcc/pe3epwithyou/trident/feature/killfeed/KillMethod;)Z", "victim", "attacker", "Lkotlin/Pair;", "", "getColors", "(Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;)Lkotlin/Pair;", "c", "", "cleanupComponent", "(Lnet/minecraft/class_2561;)Ljava/util/List;", "Lcc/pe3epwithyou/trident/state/Game;", "killfeedGames", "Ljava/util/List;", "getKillfeedGames", "()Ljava/util/List;", "fallbackColor", "I", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "streaks", "Ljava/util/HashMap;", "getStreaks", "()Ljava/util/HashMap;", "Trident"})
@SourceDebugExtension(value={"SMAP\nKillChatListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KillChatListener.kt\ncc/pe3epwithyou/trident/client/listeners/KillChatListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1869#2,2:141\n1869#2,2:143\n*S KotlinDebug\n*F\n+ 1 KillChatListener.kt\ncc/pe3epwithyou/trident/client/listeners/KillChatListener\n*L\n130#1:141,2\n43#1:143,2\n*E\n"})
public final class KillChatListener {
    @NotNull
    public static final KillChatListener INSTANCE = new KillChatListener();
    @NotNull
    private static final List<Game> killfeedGames;
    private static final int fallbackColor;
    @NotNull
    private static final HashMap<String, Integer> streaks;

    private KillChatListener() {
    }

    @NotNull
    public final List<Game> getKillfeedGames() {
        return killfeedGames;
    }

    @NotNull
    public final HashMap<String, Integer> getStreaks() {
        return streaks;
    }

    public final void resetStreaks() {
        streaks.clear();
    }

    public final void register() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(KillChatListener::register$lambda$1);
    }

    private final boolean handleKill(class_2561 message, KillMethod method) {
        KillEvents.KillEventPlayer killEventPlayer;
        List<class_2561> players = this.cleanupComponent(message);
        if (players.isEmpty()) {
            return true;
        }
        class_2561 victim = players.get(0);
        class_2561 attacker = (class_2561)CollectionsKt.getOrNull(players, (int)1);
        KillMethod killMethod = method;
        if (method == KillMethod.MAGIC) {
            String string = message.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Splash Potion", (boolean)false, (int)2, null)) {
                killMethod = KillMethod.POTION;
            }
            String string2 = message.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Orb", (boolean)false, (int)2, null)) {
                killMethod = KillMethod.ORB;
            }
        }
        KillEvents.KillEventCallback killEventCallback = (KillEvents.KillEventCallback)KillEvents.INSTANCE.getKILL().invoker();
        String string = victim.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        class_5251 class_52512 = victim.method_10866().method_10973();
        KillEvents.KillEventPlayer killEventPlayer2 = new KillEvents.KillEventPlayer(string, class_52512 != null ? class_52512.method_27716() : fallbackColor);
        if (attacker == null) {
            killEventPlayer = null;
        } else {
            String string3 = attacker.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            class_5251 class_52513 = attacker.method_10866().method_10973();
            killEventPlayer = new KillEvents.KillEventPlayer(string3, class_52513 != null ? class_52513.method_27716() : fallbackColor);
        }
        killEventCallback.onKill(killEventPlayer2, killEventPlayer, killMethod);
        if (!killfeedGames.contains((Object)MCCIState.INSTANCE.getGame())) {
            return true;
        }
        if (attacker != null) {
            class_746 class_7462 = class_310.method_1551().field_1724;
            if (class_7462 == null) {
                return true;
            }
            class_746 self = class_7462;
            if (Intrinsics.areEqual((Object)attacker.getString(), (Object)self.method_5477().getString())) {
                Game game = MCCIState.INSTANCE.getGame();
                IncrementContext incrementContext = EliminatedCriteria.get$default(EliminatedCriteria.INSTANCE, game, 0, "kill", 2, null);
                if (incrementContext == null) {
                    return true;
                }
                IncrementContext ctx = incrementContext;
                QuestStorage.INSTANCE.applyIncrement(ctx, true);
                if (killMethod == KillMethod.RANGE && game == Game.BATTLE_BOX) {
                    QuestStorage.INSTANCE.applyIncrement(new IncrementContext(Game.BATTLE_BOX, QuestCriteria.BATTLE_BOX_QUADS_RANGED_KILLS, 1, "bb_ranged_kill"), true);
                }
            }
            Map map = streaks;
            String string4 = attacker.getString();
            Integer n = streaks.get(attacker.getString());
            Integer n2 = (n != null ? n : 0) + 1;
            map.put(string4, n2);
            String string5 = victim.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            String string6 = attacker.getString();
            Pair<Integer, Integer> pair = this.getColors(victim, attacker);
            Integer n3 = streaks.get(attacker.getString());
            Intrinsics.checkNotNull((Object)n3);
            KillFeedDialog.Companion.addKill(new KillWidget(string5, killMethod, string6, pair, ((Number)n3).intValue(), false, 32, null));
        } else {
            class_5251 class_52514 = victim.method_10866().method_10973();
            int victimColor = class_52514 != null ? IntColorUtilKt.opacity((int)class_52514.method_27716(), (int)128) : fallbackColor;
            String string7 = victim.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
            KillFeedDialog.Companion.addKill(new KillWidget(string7, killMethod, null, new Pair((Object)IntColorUtilKt.opacity((int)0x606060, (int)128), (Object)victimColor), 0, false, 52, null));
        }
        return !Config.KillFeed.INSTANCE.getHideKills();
    }

    private final Pair<Integer, Integer> getColors(class_2561 victim, class_2561 attacker) {
        int victimColor;
        class_5251 class_52512 = attacker.method_10866().method_10973();
        int attackerColor = class_52512 != null ? IntColorUtilKt.opacity((int)class_52512.method_27716(), (int)128) : fallbackColor;
        class_5251 class_52513 = victim.method_10866().method_10973();
        int n = victimColor = class_52513 != null ? IntColorUtilKt.opacity((int)class_52513.method_27716(), (int)128) : fallbackColor;
        if (attackerColor == victimColor) {
            class_5251 class_52514 = victim.method_10866().method_10973();
            victimColor = class_52514 != null ? IntColorUtilKt.opacity((int)class_52514.method_27716(), (int)96) : IntColorUtilKt.opacity((int)0xFFFFFF, (int)96);
        }
        return new Pair((Object)attackerColor, (Object)victimColor);
    }

    private final List<class_2561> cleanupComponent(class_2561 c) {
        List rawList = c.method_44746();
        class_5520 socialManager = class_310.method_1551().method_31320();
        List components = new ArrayList();
        Intrinsics.checkNotNull((Object)rawList);
        Iterable $this$forEach$iv = rawList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid;
            class_2561 it = (class_2561)element$iv;
            boolean bl = false;
            int n = it.getString().length();
            if (1 <= n ? n < 3 : false) continue;
            String string = it.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"[", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)(uuid = socialManager.method_31407(it.getString())), (Object)class_156.field_25140)) continue;
            Intrinsics.checkNotNull((Object)it);
            components.add(it);
            if (components.size() != 2) continue;
            return components;
        }
        return components;
    }

    private static final boolean register$lambda$1(class_2561 message, boolean bl) {
        if (!MCCIState.INSTANCE.isOnIsland()) {
            return true;
        }
        Regex regex = new Regex("^\\[.] You assisted in eliminating (.+)!");
        String string = message.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        boolean killAssistMatch = regex.matches((CharSequence)string);
        if (killAssistMatch) {
            KillFeedDialog.Companion.applyKillAssist();
        }
        Iterable $this$forEach$iv = (Iterable)DeathMessages.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeathMessages deathMessage = (DeathMessages)((Object)element$iv);
            boolean bl2 = false;
            Regex regex2 = deathMessage.getRegex();
            String string2 = message.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            if (!regex2.matches((CharSequence)string2)) continue;
            Intrinsics.checkNotNull((Object)message);
            return INSTANCE.handleKill(message, deathMessage.getMethod());
        }
        return true;
    }

    static {
        Game[] gameArray = new Game[]{Game.BATTLE_BOX, Game.DYNABALL, Game.SKY_BATTLE, Game.ROCKET_SPLEEF_RUSH};
        killfeedGames = CollectionsKt.listOf((Object[])gameArray);
        fallbackColor = IntColorUtilKt.opacity((int)0xFFFFFF, (int)128);
        streaks = new HashMap();
    }
}

