/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.exchange;

import cc.pe3epwithyou.trident.config.Config;
import cc.pe3epwithyou.trident.feature.exchange.ActiveIslandExchangeListingsItem;
import cc.pe3epwithyou.trident.feature.exchange.Collections;
import cc.pe3epwithyou.trident.feature.exchange.Cosmetic;
import cc.pe3epwithyou.trident.feature.exchange.CosmeticsItem;
import cc.pe3epwithyou.trident.feature.exchange.ExchangeAsset;
import cc.pe3epwithyou.trident.feature.exchange.ExchangeListingsResponse;
import cc.pe3epwithyou.trident.feature.exchange.ExchangeLookup;
import cc.pe3epwithyou.trident.interfaces.exchange.ExchangeFilter;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import cc.pe3epwithyou.trident.utils.Model;
import cc.pe3epwithyou.trident.utils.Resources;
import cc.pe3epwithyou.trident.utils.Texture;
import cc.pe3epwithyou.trident.utils.extensions.ItemStackExtensions;
import com.noxcrew.sheeplib.util.IntColorUtilKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000234B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R3\u0010)\u001a\u001e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001c0&j\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001c`(8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001d\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00065"}, d2={"Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler;", "", "<init>", "()V", "Lnet/minecraft/class_437;", "screen", "", "handleScreen", "(Lnet/minecraft/class_437;)V", "updatePrices", "updateCosmetics", "Lnet/minecraft/class_1735;", "slot", "", "shouldRenderTooltip", "(Lnet/minecraft/class_1735;)Z", "Lnet/minecraft/class_332;", "graphics", "renderSlot", "(Lnet/minecraft/class_332;Lnet/minecraft/class_1735;)V", "", "left", "top", "renderBackground", "(Lnet/minecraft/class_332;II)V", "inSlotBoundary", "Lnet/minecraft/class_1799;", "item", "", "getItemPrice", "(Lnet/minecraft/class_1799;)Ljava/lang/Long;", "Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$FetchProgress;", "fetchingProgress", "Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$FetchProgress;", "getFetchingProgress", "()Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$FetchProgress;", "setFetchingProgress", "(Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$FetchProgress;)V", "Ljava/util/HashMap;", "Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$Listing;", "Lkotlin/collections/HashMap;", "exchangeDeals", "Ljava/util/HashMap;", "getExchangeDeals", "()Ljava/util/HashMap;", "", "", "ownedCosmetics", "Ljava/util/Set;", "getOwnedCosmetics", "()Ljava/util/Set;", "Listing", "FetchProgress", "Trident"})
@SourceDebugExtension(value={"SMAP\nExchangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExchangeHandler.kt\ncc/pe3epwithyou/trident/feature/exchange/ExchangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1869#2,2:157\n1869#2,2:159\n774#2:161\n865#2,2:162\n1869#2,2:164\n1869#2,2:166\n*S KotlinDebug\n*F\n+ 1 ExchangeHandler.kt\ncc/pe3epwithyou/trident/feature/exchange/ExchangeHandler\n*L\n52#1:157,2\n69#1:159,2\n82#1:161\n82#1:162,2\n84#1:164,2\n149#1:166,2\n*E\n"})
public final class ExchangeHandler {
    @NotNull
    public static final ExchangeHandler INSTANCE = new ExchangeHandler();
    @NotNull
    private static FetchProgress fetchingProgress = FetchProgress.NO_DATA;
    @NotNull
    private static final HashMap<Listing, Long> exchangeDeals = new HashMap();
    @NotNull
    private static final Set<String> ownedCosmetics = new LinkedHashSet();

    private ExchangeHandler() {
    }

    @NotNull
    public final FetchProgress getFetchingProgress() {
        return fetchingProgress;
    }

    public final void setFetchingProgress(@NotNull FetchProgress fetchProgress) {
        Intrinsics.checkNotNullParameter((Object)((Object)fetchProgress), (String)"<set-?>");
        fetchingProgress = fetchProgress;
    }

    @NotNull
    public final HashMap<Listing, Long> getExchangeDeals() {
        return exchangeDeals;
    }

    @NotNull
    public final Set<String> getOwnedCosmetics() {
        return ownedCosmetics;
    }

    public final void handleScreen(@NotNull class_437 screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (!Config.Global.INSTANCE.getExchangeImprovements()) {
            return;
        }
        class_476 chest = (class_476)screen;
        long now = Instant.now().toEpochMilli();
        if (ExchangeLookup.INSTANCE.getExchangeLookupCacheExpiresIn() != null) {
            Long l = ExchangeLookup.INSTANCE.getExchangeLookupCacheExpiresIn();
            Intrinsics.checkNotNull((Object)l);
            if (now >= l) {
                ExchangeLookup.INSTANCE.clearCache();
            }
        }
        if (ExchangeLookup.INSTANCE.getExchangeLookupCache() == null) {
            fetchingProgress = FetchProgress.LOADING;
            ExchangeLookup.INSTANCE.lookup();
        } else {
            this.updatePrices();
        }
        class_2371 class_23712 = ((class_1707)chest.method_17577()).field_7761;
        Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"slots");
        Iterable $this$forEach$iv = (Iterable)class_23712;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1735 slot = (class_1735)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)slot);
            if (!INSTANCE.inSlotBoundary(slot)) continue;
            class_1799 item = slot.method_7677();
            Intrinsics.checkNotNull((Object)item);
            Long l = INSTANCE.getItemPrice(item);
            if (l == null) {
                continue;
            }
            long price = l;
            String string = item.method_7954().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String itemName = StringsKt.replace$default((String)string, (String)" Token", (String)"", (boolean)false, (int)4, null);
            Listing listing = new Listing(itemName, slot.method_7677().method_7947());
            Long current = exchangeDeals.get(listing);
            if (current != null && price >= current) continue;
            ChatUtils.INSTANCE.debugLog("(SCREEN) Updating price for " + listing + " -> " + price);
            ((Map)exchangeDeals).put(listing, price);
        }
    }

    public final void updatePrices() {
        ExchangeListingsResponse exchangeListingsResponse = ExchangeLookup.INSTANCE.getExchangeLookupCache();
        Intrinsics.checkNotNull((Object)exchangeListingsResponse);
        Iterable $this$forEach$iv = exchangeListingsResponse.getData().getActiveIslandExchangeListings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActiveIslandExchangeListingsItem activeIslandExchangeListingsItem = (ActiveIslandExchangeListingsItem)element$iv;
            boolean bl = false;
            long cost = activeIslandExchangeListingsItem.component1();
            ExchangeAsset asset = activeIslandExchangeListingsItem.component2();
            int amount = activeIslandExchangeListingsItem.component3();
            String name = StringsKt.replace$default((String)("[" + asset.getName() + "]"), (String)" Token", (String)"", (boolean)false, (int)4, null);
            Listing listing = new Listing(name, amount);
            Long current = exchangeDeals.get(listing);
            if (current != null && cost >= current) continue;
            ChatUtils.INSTANCE.debugLog("(API) Updating price for " + listing + " -> " + cost);
            ((Map)exchangeDeals).put(listing, cost);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCosmetics() {
        void $this$filterTo$iv$iv;
        ExchangeListingsResponse exchangeListingsResponse = ExchangeLookup.INSTANCE.getExchangeLookupCache();
        Intrinsics.checkNotNull((Object)exchangeListingsResponse);
        Collections collections = exchangeListingsResponse.getData().getPlayer().getCollections();
        if (collections == null) {
            return;
        }
        Collections collections2 = collections;
        Iterable $this$filter$iv = collections2.getCosmetics();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CosmeticsItem cosmeticsItem = (CosmeticsItem)element$iv$iv;
            boolean bl = false;
            boolean owned = cosmeticsItem.component1();
            if (!owned) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        ownedCosmetics.clear();
        Iterable $this$forEach$iv = filtered;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CosmeticsItem cosmeticsItem = (CosmeticsItem)element$iv;
            boolean bl = false;
            Cosmetic cosmetic = cosmeticsItem.component2();
            ownedCosmetics.add("[" + cosmetic.getName() + "]");
        }
    }

    public final boolean shouldRenderTooltip(@NotNull class_1735 slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (!Config.Global.INSTANCE.getExchangeImprovements()) {
            return true;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 == null) {
            return true;
        }
        class_437 screen = class_4372;
        String string = screen.method_25440().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"ISLAND EXCHANGE", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!this.inSlotBoundary(slot)) {
            return true;
        }
        if (fetchingProgress.isLoading()) {
            return true;
        }
        if (ExchangeFilter.Companion.getShowOwnedItems()) {
            return true;
        }
        String string2 = slot.method_7677().method_7954().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String itemName = StringsKt.replace$default((String)string2, (String)" Token", (String)"", (boolean)false, (int)4, null);
        return !ownedCosmetics.contains(itemName);
    }

    public final void renderSlot(@NotNull class_332 graphics, @NotNull class_1735 slot) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (!Config.Global.INSTANCE.getExchangeImprovements()) {
            return;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 == null) {
            return;
        }
        class_437 screen = class_4372;
        String string = screen.method_25440().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"ISLAND EXCHANGE", (boolean)false, (int)2, null)) {
            return;
        }
        if (!this.inSlotBoundary(slot)) {
            return;
        }
        if (fetchingProgress.isLoading()) {
            return;
        }
        if (fetchingProgress == FetchProgress.FAILED) {
            return;
        }
        String string2 = slot.method_7677().method_7954().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String itemName = StringsKt.replace$default((String)string2, (String)" Token", (String)"", (boolean)false, (int)4, null);
        if (ownedCosmetics.contains(itemName) && !ExchangeFilter.Companion.getShowOwnedItems()) {
            graphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, IntColorUtilKt.opacity((int)3298705, (int)128));
            return;
        }
        class_1799 class_17992 = slot.method_7677();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItem(...)");
        Long l = this.getItemPrice(class_17992);
        if (l == null) {
            return;
        }
        long price = l;
        Listing listing = new Listing(itemName, slot.method_7677().method_7947());
        if (((Map)exchangeDeals).containsKey(listing)) {
            Long l2 = exchangeDeals.get(listing);
            long l3 = price;
            if (l2 != null && l2 == l3) {
                Texture.blit$default(new Texture(Resources.INSTANCE.trident("textures/interface/exchange/star.png"), 7, 6, 0, 0, null, 56, null), graphics, slot.field_7873 + 10, slot.field_7872 - 1, 0, 8, null);
            }
        }
    }

    public final void renderBackground(@NotNull class_332 graphics, int left, int top) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (!Config.Global.INSTANCE.getExchangeImprovements()) {
            return;
        }
        if (!fetchingProgress.isLoading()) {
            return;
        }
        new Model(Resources.INSTANCE.trident("interface/loading"), 8, 8, 0, 8, null).render(graphics, left + 160, top - 30);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inSlotBoundary(class_1735 slot) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n = slot.field_7874;
        if (10 <= n) {
            if (n < 17) {
                return true;
            }
            bl4 = false;
        } else {
            bl4 = false;
        }
        if (bl4) return true;
        n = slot.field_7874;
        if (19 <= n) {
            if (n < 26) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        n = slot.field_7874;
        if (28 <= n) {
            if (n < 35) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        n = slot.field_7874;
        if (37 <= n) {
            if (n < 44) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = slot.field_7874;
        if (46 > n) return false;
        if (n >= 53) return false;
        return true;
    }

    private final Long getItemPrice(class_1799 item) {
        List priceLines = CollectionsKt.reversed((Iterable)ItemStackExtensions.INSTANCE.getLore(item));
        if (priceLines.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = priceLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2561 priceLine = (class_2561)element$iv;
            boolean bl = false;
            Regex regex = new Regex("Listed Price: .((?:\\d+|,)+)");
            String string = priceLine.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            MatchResult matchResult = regex.matchEntire((CharSequence)string);
            if (matchResult == null) continue;
            MatchResult match = matchResult;
            Object object = match.getGroups().get(1);
            if (object == null || (object = object.getValue()) == null || (object = StringsKt.replace$default((String)object, (String)",", (String)"", (boolean)false, (int)4, null)) == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
                return null;
            }
            long price = (Long)object;
            return price;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$FetchProgress;", "", "<init>", "(Ljava/lang/String;I)V", "", "isLoading", "()Z", "NO_DATA", "LOADING", "COMPLETED", "FAILED", "Trident"})
    public static final class FetchProgress
    extends Enum<FetchProgress> {
        public static final /* enum */ FetchProgress NO_DATA = new FetchProgress();
        public static final /* enum */ FetchProgress LOADING = new FetchProgress();
        public static final /* enum */ FetchProgress COMPLETED = new FetchProgress();
        public static final /* enum */ FetchProgress FAILED = new FetchProgress();
        private static final /* synthetic */ FetchProgress[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isLoading() {
            return this == NO_DATA || this == LOADING;
        }

        public static FetchProgress[] values() {
            return (FetchProgress[])$VALUES.clone();
        }

        public static FetchProgress valueOf(String value) {
            return Enum.valueOf(FetchProgress.class, value);
        }

        @NotNull
        public static EnumEntries<FetchProgress> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fetchProgressArray = new FetchProgress[]{FetchProgress.NO_DATA, FetchProgress.LOADING, FetchProgress.COMPLETED, FetchProgress.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$Listing;", "", "", "name", "", "amount", "<init>", "(Ljava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "()I", "copy", "(Ljava/lang/String;I)Lcc/pe3epwithyou/trident/feature/exchange/ExchangeHandler$Listing;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "I", "getAmount", "Trident"})
    public static final class Listing {
        @NotNull
        private final String name;
        private final int amount;

        public Listing(@NotNull String name, int amount) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.amount = amount;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.amount;
        }

        @NotNull
        public final Listing copy(@NotNull String name, int amount) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Listing(name, amount);
        }

        public static /* synthetic */ Listing copy$default(Listing listing, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = listing.name;
            }
            if ((n2 & 2) != 0) {
                n = listing.amount;
            }
            return listing.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Listing(name=" + this.name + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Listing)) {
                return false;
            }
            Listing listing = (Listing)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)listing.name)) {
                return false;
            }
            return this.amount == listing.amount;
        }
    }
}

