/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.fishing;

import cc.pe3epwithyou.trident.feature.fishing.OverclockClock;
import cc.pe3epwithyou.trident.state.OverclockState;
import cc.pe3epwithyou.trident.state.PlayerStateIO;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcc/pe3epwithyou/trident/feature/fishing/OverclockHandlers;", "", "<init>", "()V", "", "name", "Lcc/pe3epwithyou/trident/state/OverclockState;", "overclock", "", "startTimedOverclock", "(Ljava/lang/String;Lcc/pe3epwithyou/trident/state/OverclockState;)V", "Trident"})
public final class OverclockHandlers {
    @NotNull
    public static final OverclockHandlers INSTANCE = new OverclockHandlers();

    private OverclockHandlers() {
    }

    public final void startTimedOverclock(@NotNull String name, @NotNull OverclockState overclock) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)overclock, (String)"overclock");
        overclock.setActive(true);
        overclock.setCooldown(false);
        long now = Instant.now().toEpochMilli();
        long activeUntil = now + Duration.ofSeconds(overclock.getDuration()).toMillis();
        long availableIn = now + Duration.ofSeconds(overclock.getDuration()).toMillis() + Duration.ofSeconds(overclock.getCooldownDuration()).toMillis();
        overclock.setActiveUntil(activeUntil);
        overclock.setAvailableIn(availableIn);
        OverclockClock.INSTANCE.registerHandler(new OverclockClock.ClockHandler(name, overclock));
        PlayerStateIO.INSTANCE.save();
    }
}

