/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.questing;

import cc.pe3epwithyou.trident.feature.questing.IncrementContext;
import cc.pe3epwithyou.trident.feature.questing.Quest;
import cc.pe3epwithyou.trident.feature.questing.QuestCriteria;
import cc.pe3epwithyou.trident.feature.questing.QuestListener;
import cc.pe3epwithyou.trident.interfaces.DialogCollection;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import cc.pe3epwithyou.trident.utils.WorldUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R&\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0017R\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\u00a8\u0006%"}, d2={"Lcc/pe3epwithyou/trident/feature/questing/QuestStorage;", "", "<init>", "()V", "Lcc/pe3epwithyou/trident/state/Game;", "game", "", "Lcc/pe3epwithyou/trident/feature/questing/Quest;", "getActiveQuests", "(Lcc/pe3epwithyou/trident/state/Game;)Ljava/util/List;", "quests", "", "loadQuests", "(Ljava/util/List;)V", "Lcc/pe3epwithyou/trident/feature/questing/IncrementContext;", "ctx", "", "canBeDuplicated", "applyIncrement", "(Lcc/pe3epwithyou/trident/feature/questing/IncrementContext;Z)Z", "", "", "store", "Ljava/util/Map;", "Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "", "lastOperation", "", "dailyRemaining", "I", "getDailyRemaining", "()I", "setDailyRemaining", "(I)V", "weeklyRemaining", "getWeeklyRemaining", "setWeeklyRemaining", "Trident"})
public final class QuestStorage {
    @NotNull
    public static final QuestStorage INSTANCE = new QuestStorage();
    @NotNull
    private static final Map<Game, List<Quest>> store = new ConcurrentHashMap();
    @NotNull
    private static final Map<QuestCriteria, String> lastOperation = new ConcurrentHashMap();
    private static int dailyRemaining;
    private static int weeklyRemaining;

    private QuestStorage() {
    }

    public final int getDailyRemaining() {
        return dailyRemaining;
    }

    public final void setDailyRemaining(int n) {
        dailyRemaining = n;
    }

    public final int getWeeklyRemaining() {
        return weeklyRemaining;
    }

    public final void setWeeklyRemaining(int n) {
        weeklyRemaining = n;
    }

    @NotNull
    public final List<Quest> getActiveQuests(@NotNull Game game) {
        Intrinsics.checkNotNullParameter((Object)((Object)game), (String)"game");
        List list = store.get((Object)game);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void loadQuests(@NotNull List<Quest> quests) {
        Intrinsics.checkNotNullParameter(quests, (String)"quests");
        for (Game g : Game.getEntries()) {
            List<Quest> list = store.get((Object)g);
            if (list != null) {
                list.clear();
                continue;
            }
            store.put(g, new CopyOnWriteArrayList());
        }
        for (Quest q : quests) {
            List list;
            Intrinsics.checkNotNullExpressionValue((Object)store.computeIfAbsent(q.getGame(), arg_0 -> QuestStorage.loadQuests$lambda$1(QuestStorage::loadQuests$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
            list.add(q);
        }
        DialogCollection.INSTANCE.refreshDialog("questing");
    }

    public final boolean applyIncrement(@NotNull IncrementContext ctx, boolean canBeDuplicated) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ChatUtils.INSTANCE.debugLog("Received increment from context " + ctx.getSourceTag() + ": amount: " + ctx.getAmount());
        if (QuestListener.INSTANCE.checkIfPlobby()) {
            return false;
        }
        String id = WorldUtils.INSTANCE.getGameID();
        if (!canBeDuplicated && Intrinsics.areEqual((Object)lastOperation.get((Object)ctx.getCriteria()), (Object)id)) {
            ChatUtils.INSTANCE.warn("Got duplicate context increment by " + ctx.getAmount() + " from " + ctx.getSourceTag());
            return false;
        }
        List<Quest> list = store.get((Object)ctx.getGame());
        if (list == null) {
            return false;
        }
        List<Quest> quests = list;
        boolean updated = false;
        for (Quest q : quests) {
            if (q.getCriteria() != ctx.getCriteria() || q.isCompleted()) continue;
            q.increment(ctx.getAmount());
            if (!canBeDuplicated) {
                lastOperation.put(ctx.getCriteria(), id);
            }
            updated = true;
        }
        if (updated) {
            DialogCollection.INSTANCE.refreshDialog("questing");
        }
        return updated;
    }

    public static /* synthetic */ boolean applyIncrement$default(QuestStorage questStorage, IncrementContext incrementContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return questStorage.applyIncrement(incrementContext, bl);
    }

    private static final List loadQuests$lambda$0(Game it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new CopyOnWriteArrayList();
    }

    private static final List loadQuests$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        for (Game g : Game.getEntries()) {
            store.put(g, new CopyOnWriteArrayList());
        }
    }
}

