/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.interfaces;

import cc.pe3epwithyou.trident.interfaces.DialogIO;
import cc.pe3epwithyou.trident.interfaces.shared.TridentDialog;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import com.noxcrew.sheeplib.DialogContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_310;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\nJ\r\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0003J\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0012J\r\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0004\b\u0019\u0010\u0003J\r\u0010\u001a\u001a\u00020\b\u00a2\u0006\u0004\b\u001a\u0010\u0003J)\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010 J=\u0010)\u001a\u00020(2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b)\u0010*JO\u00103\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b3\u00104R \u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b8\u00109R \u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00107\u00a8\u0006<"}, d2={"Lcc/pe3epwithyou/trident/interfaces/DialogCollection;", "", "<init>", "()V", "", "key", "Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog;", "dialog", "", "open", "(Ljava/lang/String;Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog;)V", "Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog$Position;", "position", "positionDialog", "(Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog;Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog$Position;)V", "get", "(Ljava/lang/String;)Lcc/pe3epwithyou/trident/interfaces/shared/TridentDialog;", "remove", "(Ljava/lang/String;)V", "close", "saveDialogPosition", "saveAllDialogs", "loadAllDialogs", "refreshDialog", "refreshOpenedDialogs", "clear", "resetDialogPositions", "", "newWidth", "newHeight", "Lkotlin/Pair;", "findPositionForNewDialog", "(II)Lkotlin/Pair;", "", "Lcc/pe3epwithyou/trident/interfaces/DialogCollection$Dialog;", "existingDialogs", "x", "y", "width", "height", "", "isOverlapping", "(Ljava/util/List;IIII)Z", "x1", "y1", "w1", "h1", "x2", "y2", "w2", "h2", "rectanglesOverlap", "(IIIIIIII)Z", "", "openedDialogs", "Ljava/util/Map;", "DIALOG_GAP", "I", "dialogPositions", "Dialog", "Trident"})
@SourceDebugExtension(value={"SMAP\nDialogCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogCollection.kt\ncc/pe3epwithyou/trident/interfaces/DialogCollection\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n216#2,2:245\n1869#3,2:247\n1869#3,2:249\n1869#3,2:251\n1563#3:253\n1634#3,3:254\n774#3:257\n865#3,2:258\n1056#3:260\n*S KotlinDebug\n*F\n+ 1 DialogCollection.kt\ncc/pe3epwithyou/trident/interfaces/DialogCollection\n*L\n97#1:245,2\n116#1:247,2\n126#1:249,2\n140#1:251,2\n157#1:253\n157#1:254,3\n191#1:257\n191#1:258,2\n194#1:260\n*E\n"})
public final class DialogCollection {
    @NotNull
    public static final DialogCollection INSTANCE = new DialogCollection();
    @NotNull
    private static final Map<String, TridentDialog> openedDialogs = new LinkedHashMap();
    private static final int DIALOG_GAP = 5;
    @NotNull
    private static final Map<String, TridentDialog.Position> dialogPositions = new LinkedHashMap();

    private DialogCollection() {
    }

    public final void open(@NotNull String key, @NotNull TridentDialog dialog) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)dialog), (String)"dialog");
        if (openedDialogs.containsKey(key)) {
            return;
        }
        DialogContainer.INSTANCE.plusAssign((class_364)dialog);
        if (dialogPositions.containsKey(key)) {
            TridentDialog.Position position = dialogPositions.get(key);
            Intrinsics.checkNotNull((Object)position);
            TridentDialog.Position position2 = position;
            this.positionDialog(dialog, position2);
        } else {
            Pair<Integer, Integer> pair = this.findPositionForNewDialog(dialog.method_25368(), dialog.method_25364());
            int x = ((Number)pair.component1()).intValue();
            int y = ((Number)pair.component2()).intValue();
            TridentDialog.SideDistances distances = TridentDialog.Companion.getDistances(x, y, dialog.method_25368(), dialog.method_25364());
            this.positionDialog(dialog, new TridentDialog.Position(x, y, distances));
        }
        openedDialogs.putIfAbsent(key, dialog);
    }

    private final void positionDialog(TridentDialog dialog, TridentDialog.Position position) {
        TridentDialog.SideDistances distances = position.getDistances();
        if (distances == null) {
            distances = TridentDialog.Companion.getDistances(position.getX(), position.getY(), dialog.method_25368(), dialog.method_25364());
        }
        TridentDialog.Quadrant quad = TridentDialog.Companion.getQuadrant(distances);
        dialog.applyQuadrantPositioning(quad, distances);
    }

    @Nullable
    public final TridentDialog get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!openedDialogs.containsKey(key)) {
            return null;
        }
        return openedDialogs.get(key);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        openedDialogs.remove(key);
    }

    public final void close(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!openedDialogs.containsKey(key)) {
            return;
        }
        TridentDialog tridentDialog = openedDialogs.get(key);
        Intrinsics.checkNotNull((Object)((Object)tridentDialog));
        TridentDialog d = tridentDialog;
        this.saveDialogPosition(key, d);
        TridentDialog tridentDialog2 = openedDialogs.get(key);
        if (tridentDialog2 != null) {
            tridentDialog2.close();
        }
        openedDialogs.remove(key);
    }

    public final void saveDialogPosition(@NotNull String key, @NotNull TridentDialog dialog) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)dialog), (String)"dialog");
        dialogPositions.put(key, dialog.getPosition());
    }

    public final void saveAllDialogs() {
        try {
            DialogIO.INSTANCE.save(dialogPositions);
        }
        catch (Exception e) {
            ChatUtils.INSTANCE.error("Failed to save dialogs: " + e.getMessage());
        }
    }

    public final void loadAllDialogs() {
        Map<String, TridentDialog.Position> pos;
        Map<String, TridentDialog.Position> $this$forEach$iv = pos = DialogIO.INSTANCE.load();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, TridentDialog.Position>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TridentDialog.Position> element$iv;
            Map.Entry<String, TridentDialog.Position> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            TridentDialog.Position position = entry.getValue();
            dialogPositions.put(key, position);
        }
    }

    public final void refreshDialog(@NotNull String key) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!openedDialogs.containsKey(key)) {
                return;
            }
            TridentDialog tridentDialog = openedDialogs.get(key);
            if (tridentDialog == null) break block1;
            tridentDialog.refresh();
        }
    }

    public final void refreshOpenedDialogs() {
        Iterable $this$forEach$iv = openedDialogs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TridentDialog d = (TridentDialog)((Object)element$iv);
            boolean bl = false;
            d.refresh();
        }
    }

    public final void clear() {
        List keys = CollectionsKt.toList((Iterable)openedDialogs.keySet());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            ChatUtils.INSTANCE.debugLog("Attempting to clear " + key);
            TridentDialog tridentDialog = openedDialogs.get(key);
            if (tridentDialog == null) continue;
            tridentDialog.close();
        }
    }

    public final void resetDialogPositions() {
        dialogPositions.clear();
        this.saveAllDialogs();
        Iterable $this$forEach$iv = openedDialogs.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            TridentDialog dialog = (TridentDialog)((Object)entry.getValue());
            Pair<Integer, Integer> pair = INSTANCE.findPositionForNewDialog(dialog.method_25368(), dialog.method_25364());
            int x = ((Number)pair.component1()).intValue();
            int y = ((Number)pair.component2()).intValue();
            TridentDialog.SideDistances distances = TridentDialog.Companion.getDistances(x, y, dialog.method_25368(), dialog.method_25364());
            INSTANCE.positionDialog(dialog, new TridentDialog.Position(x, y, distances));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> findPositionForNewDialog(int newWidth, int newHeight) {
        void $this$filterTo$iv$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv = openedDialogs.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            TridentDialog tridentDialog = (TridentDialog)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Dialog(it.method_46426(), it.method_46427(), it.method_25368(), it.method_25364()));
        }
        List existingDialogs = (List)destination$iv$iv;
        Pair cornerPos = new Pair((Object)10, (Object)10);
        if (existingDialogs.isEmpty()) {
            return cornerPos;
        }
        Set candidates = new LinkedHashSet();
        candidates.add(cornerPos);
        for (Dialog dialog : existingDialogs) {
            candidates.add(new Pair((Object)(dialog.getX() + dialog.getWidth() + 5), (Object)dialog.getY()));
            candidates.add(new Pair((Object)Math.max(((Number)cornerPos.getFirst()).intValue(), dialog.getX() - newWidth - 5), (Object)dialog.getY()));
            candidates.add(new Pair((Object)dialog.getX(), (Object)(dialog.getY() + dialog.getHeight() + 5)));
            candidates.add(new Pair((Object)dialog.getX(), (Object)Math.max(((Number)cornerPos.getSecond()).intValue(), dialog.getY() - newHeight - 5)));
            candidates.add(new Pair((Object)(dialog.getX() + dialog.getWidth() + 5), (Object)(dialog.getY() + dialog.getHeight() + 5)));
            candidates.add(new Pair((Object)Math.max(((Number)cornerPos.getFirst()).intValue(), dialog.getX() - newWidth - 5), (Object)(dialog.getY() + dialog.getHeight() + 5)));
            candidates.add(new Pair((Object)(dialog.getX() + dialog.getWidth() + 5), (Object)Math.max(((Number)cornerPos.getSecond()).intValue(), dialog.getY() - newHeight - 5)));
        }
        Iterable $this$filter$iv = candidates;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getFirst()).intValue() >= 0 && ((Number)it.getSecond()).intValue() >= 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filteredCandidates = (List)destination$iv$iv2;
        Iterable $this$sortedBy$iv = filteredCandidates;
        boolean $i$f$sortedBy2 = false;
        List sortedCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(cornerPos){
            final /* synthetic */ Pair $cornerPos$inlined;
            {
                this.$cornerPos$inlined = pair;
            }

            public final int compare(T a, T b) {
                Pair candidate = (Pair)a;
                boolean bl = false;
                int dx = ((Number)candidate.getFirst()).intValue() - ((Number)this.$cornerPos$inlined.getFirst()).intValue();
                int dy = ((Number)candidate.getSecond()).intValue() - ((Number)this.$cornerPos$inlined.getSecond()).intValue();
                candidate = (Pair)b;
                Comparable comparable = Integer.valueOf(dx * dx + dy * dy);
                bl = false;
                dx = ((Number)candidate.getFirst()).intValue() - ((Number)this.$cornerPos$inlined.getFirst()).intValue();
                dy = ((Number)candidate.getSecond()).intValue() - ((Number)this.$cornerPos$inlined.getSecond()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(dx * dx + dy * dy));
            }
        });
        for (Pair $i$f$sortedBy2 : sortedCandidates) {
            int y;
            int x = ((Number)$i$f$sortedBy2.component1()).intValue();
            if (this.isOverlapping(existingDialogs, x, y = ((Number)$i$f$sortedBy2.component2()).intValue(), newWidth, newHeight)) continue;
            return new Pair((Object)x, (Object)y);
        }
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        for (int y = ((Number)cornerPos.getSecond()).intValue(); y < screenHeight; y += 5 + newHeight) {
            for (int x = ((Number)cornerPos.getFirst()).intValue(); x < screenWidth; x += 5 + newWidth) {
                if (this.isOverlapping(existingDialogs, x, y, newWidth, newHeight)) continue;
                return new Pair((Object)x, (Object)y);
            }
        }
        return cornerPos;
    }

    private final boolean isOverlapping(List<Dialog> existingDialogs, int x, int y, int width, int height) {
        for (Dialog dialog : existingDialogs) {
            if (!this.rectanglesOverlap(dialog.getX(), dialog.getY(), dialog.getWidth(), dialog.getHeight(), x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    private final boolean rectanglesOverlap(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 + w1 > x2 && x2 + w2 > x1 && y1 + h1 > y2 && y2 + h2 > y1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001c\u0010\n\u00a8\u0006\u001d"}, d2={"Lcc/pe3epwithyou/trident/interfaces/DialogCollection$Dialog;", "", "", "x", "y", "width", "height", "<init>", "(IIII)V", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lcc/pe3epwithyou/trident/interfaces/DialogCollection$Dialog;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getX", "getY", "getWidth", "getHeight", "Trident"})
    private static final class Dialog {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public Dialog(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final Dialog copy(int x, int y, int width, int height) {
            return new Dialog(x, y, width, height);
        }

        public static /* synthetic */ Dialog copy$default(Dialog dialog, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = dialog.x;
            }
            if ((n5 & 2) != 0) {
                n2 = dialog.y;
            }
            if ((n5 & 4) != 0) {
                n3 = dialog.width;
            }
            if ((n5 & 8) != 0) {
                n4 = dialog.height;
            }
            return dialog.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Dialog(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dialog)) {
                return false;
            }
            Dialog dialog = (Dialog)other;
            if (this.x != dialog.x) {
                return false;
            }
            if (this.y != dialog.y) {
                return false;
            }
            if (this.width != dialog.width) {
                return false;
            }
            return this.height == dialog.height;
        }
    }
}

