/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.questing;

import cc.pe3epwithyou.trident.feature.questing.QuestCriteria;
import cc.pe3epwithyou.trident.feature.questing.QuestSubtype;
import cc.pe3epwithyou.trident.feature.questing.QuestType;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.state.Rarity;
import cc.pe3epwithyou.trident.utils.Resources;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010!\u001a\u0004\b\"\u0010#R\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0017\u0010\u000e\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010$\u001a\u0004\b)\u0010&R\u0011\u0010-\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00065"}, d2={"Lcc/pe3epwithyou/trident/feature/questing/Quest;", "", "Lcc/pe3epwithyou/trident/state/Game;", "game", "Lcc/pe3epwithyou/trident/feature/questing/QuestType;", "type", "Lcc/pe3epwithyou/trident/feature/questing/QuestSubtype;", "subtype", "Lcc/pe3epwithyou/trident/state/Rarity;", "rarity", "Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "criteria", "", "progress", "totalProgress", "<init>", "(Lcc/pe3epwithyou/trident/state/Game;Lcc/pe3epwithyou/trident/feature/questing/QuestType;Lcc/pe3epwithyou/trident/feature/questing/QuestSubtype;Lcc/pe3epwithyou/trident/state/Rarity;Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;II)V", "amount", "", "increment", "(I)Z", "Lcc/pe3epwithyou/trident/state/Game;", "getGame", "()Lcc/pe3epwithyou/trident/state/Game;", "Lcc/pe3epwithyou/trident/feature/questing/QuestType;", "getType", "()Lcc/pe3epwithyou/trident/feature/questing/QuestType;", "Lcc/pe3epwithyou/trident/feature/questing/QuestSubtype;", "getSubtype", "()Lcc/pe3epwithyou/trident/feature/questing/QuestSubtype;", "Lcc/pe3epwithyou/trident/state/Rarity;", "getRarity", "()Lcc/pe3epwithyou/trident/state/Rarity;", "Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "getCriteria", "()Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "I", "getProgress", "()I", "setProgress", "(I)V", "getTotalProgress", "Lnet/minecraft/class_2960;", "getSprite", "()Lnet/minecraft/class_2960;", "sprite", "", "display_name", "Ljava/lang/String;", "getDisplay_name", "()Ljava/lang/String;", "isCompleted", "()Z", "Trident"})
public final class Quest {
    @NotNull
    private final Game game;
    @NotNull
    private final QuestType type;
    @NotNull
    private final QuestSubtype subtype;
    @NotNull
    private final Rarity rarity;
    @NotNull
    private final QuestCriteria criteria;
    private int progress;
    private final int totalProgress;
    @NotNull
    private final String display_name;

    public Quest(@NotNull Game game, @NotNull QuestType type, @NotNull QuestSubtype subtype, @NotNull Rarity rarity, @NotNull QuestCriteria criteria, int progress, int totalProgress) {
        Intrinsics.checkNotNullParameter((Object)((Object)game), (String)"game");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)subtype), (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        Intrinsics.checkNotNullParameter((Object)((Object)criteria), (String)"criteria");
        this.game = game;
        this.type = type;
        this.subtype = subtype;
        this.rarity = rarity;
        this.criteria = criteria;
        this.progress = progress;
        this.totalProgress = totalProgress;
        this.display_name = this.criteria.getShortName();
    }

    @NotNull
    public final Game getGame() {
        return this.game;
    }

    @NotNull
    public final QuestType getType() {
        return this.type;
    }

    @NotNull
    public final QuestSubtype getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final Rarity getRarity() {
        return this.rarity;
    }

    @NotNull
    public final QuestCriteria getCriteria() {
        return this.criteria;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n) {
        this.progress = n;
    }

    public final int getTotalProgress() {
        return this.totalProgress;
    }

    @NotNull
    public final class_2960 getSprite() {
        String directory = this.type.getDirectoryPath();
        String string = this.rarity.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String raritySuffix = string;
        return Resources.INSTANCE.mcc("textures/" + directory + raritySuffix + ".png");
    }

    @NotNull
    public final String getDisplay_name() {
        return this.display_name;
    }

    public final boolean isCompleted() {
        return this.progress >= this.totalProgress;
    }

    public final boolean increment(int amount) {
        if (this.isCompleted()) {
            return false;
        }
        this.progress = RangesKt.coerceAtMost((int)(this.progress + amount), (int)this.totalProgress);
        return this.isCompleted();
    }
}

