/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.questing;

import cc.pe3epwithyou.trident.client.listeners.ChestScreenListener;
import cc.pe3epwithyou.trident.config.Config;
import cc.pe3epwithyou.trident.feature.questing.Quest;
import cc.pe3epwithyou.trident.feature.questing.QuestStorage;
import cc.pe3epwithyou.trident.feature.questing.game.BattleBoxHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.DynaballHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.HITWHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.PKWDojoHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.PKWSurvivorHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.RSRHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.SkyBattleHandlers;
import cc.pe3epwithyou.trident.feature.questing.game.TGTTOSHandlers;
import cc.pe3epwithyou.trident.interfaces.questing.QuestingDialog;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.state.MCCIState;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import cc.pe3epwithyou.trident.utils.DelayedAction;
import cc.pe3epwithyou.trident.utils.WorldUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\bJ-\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0003J\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\bJ\r\u0010\u0019\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001aR#\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b#\u0010\u001a\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcc/pe3epwithyou/trident/feature/questing/QuestListener;", "", "<init>", "()V", "Lnet/minecraft/class_2561;", "m", "", "handleRefreshTasksChat", "(Lnet/minecraft/class_2561;)V", "Lnet/minecraft/class_1799;", "item", "handleRefreshTasksItem", "(Lnet/minecraft/class_1799;)V", "handleSubtitle", "", "minutes", "", "shouldInterrupt", "Lkotlin/Function0;", "action", "handleTimedQuest", "(JZLkotlin/jvm/functions/Function0;)V", "interruptTasks", "register", "checkDesynced", "isAQuestCompleted", "()Z", "checkIfPlobby", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcc/pe3epwithyou/trident/utils/DelayedAction$DelayedTask;", "interruptibleTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "getInterruptibleTasks", "()Ljava/util/concurrent/ConcurrentHashMap;", "isWaitingRefresh", "Z", "setWaitingRefresh", "(Z)V", "Trident"})
@SourceDebugExtension(value={"SMAP\nQuestListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestListener.kt\ncc/pe3epwithyou/trident/feature/questing/QuestListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n216#2,2:102\n1869#3,2:104\n*S KotlinDebug\n*F\n+ 1 QuestListener.kt\ncc/pe3epwithyou/trident/feature/questing/QuestListener\n*L\n58#1:102,2\n90#1:104,2\n*E\n"})
public final class QuestListener {
    @NotNull
    public static final QuestListener INSTANCE = new QuestListener();
    @NotNull
    private static final ConcurrentHashMap<UUID, DelayedAction.DelayedTask> interruptibleTasks = new ConcurrentHashMap();
    private static boolean isWaitingRefresh;

    private QuestListener() {
    }

    @NotNull
    public final ConcurrentHashMap<UUID, DelayedAction.DelayedTask> getInterruptibleTasks() {
        return interruptibleTasks;
    }

    public final boolean isWaitingRefresh() {
        return isWaitingRefresh;
    }

    public final void setWaitingRefresh(boolean bl) {
        isWaitingRefresh = bl;
    }

    public final void handleRefreshTasksChat(@NotNull class_2561 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Regex regex = new Regex("^\\(.\\) Quest Tasks Rerolled!");
        String string = m.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (!regex.matches((CharSequence)string)) {
            return;
        }
        isWaitingRefresh = true;
    }

    public final void handleRefreshTasksItem(@NotNull class_1799 item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!isWaitingRefresh) {
            return;
        }
        String string = item.method_7964().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Quest", (boolean)false, (int)2, null)) {
            return;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 == null) {
            return;
        }
        class_476 screen = (class_476)class_4372;
        ChestScreenListener.INSTANCE.findQuests(screen);
    }

    public final void handleSubtitle(@NotNull class_2561 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (!Config.Questing.INSTANCE.getEnabled()) {
            return;
        }
        if (MCCIState.INSTANCE.getGame() == Game.PARKOUR_WARRIOR_DOJO) {
            PKWDojoHandlers.INSTANCE.handle(m);
        }
        if (MCCIState.INSTANCE.getGame() == Game.HITW) {
            HITWHandlers.INSTANCE.handlePlacement(m);
        }
    }

    public final void handleTimedQuest(long minutes, boolean shouldInterrupt, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!Config.Questing.INSTANCE.getEnabled()) {
            return;
        }
        String initialID = WorldUtils.INSTANCE.getGameID();
        DelayedAction.DelayedTask task = DelayedAction.INSTANCE.delay(TimeUnit.MINUTES.toMillis(minutes), (Function0<Unit>)((Function0)() -> QuestListener.handleTimedQuest$lambda$0(initialID, action)));
        ChatUtils.INSTANCE.debugLog("Scheduled task with: " + task.getId());
        if (!shouldInterrupt) {
            return;
        }
        ((Map)interruptibleTasks).put(task.getId(), task);
    }

    public static /* synthetic */ void handleTimedQuest$default(QuestListener questListener, long l, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        questListener.handleTimedQuest(l, bl, (Function0<Unit>)function0);
    }

    public final void interruptTasks() {
        Map $this$forEach$iv = interruptibleTasks;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DelayedAction.DelayedTask task = (DelayedAction.DelayedTask)entry.getValue();
            task.cancel();
        }
        interruptibleTasks.clear();
    }

    public final void register() {
        ClientReceiveMessageEvents.GAME.register(QuestListener::register$lambda$2);
    }

    public final void checkDesynced(@NotNull class_2561 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Regex regex = new Regex("\\(.\\) (Quest Scroll|Quest) Completed! Check your Quest Log for rewards\\.");
        String string = m.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        boolean match = regex.matches((CharSequence)string);
        if (!match) {
            return;
        }
        if (this.isAQuestCompleted()) {
            return;
        }
        QuestingDialog.Companion.setDesynced(true);
    }

    public final boolean isAQuestCompleted() {
        Iterable $this$forEach$iv = QuestStorage.INSTANCE.getActiveQuests(MCCIState.INSTANCE.getGame());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Quest q = (Quest)element$iv;
            boolean bl = false;
            if (!q.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public final boolean checkIfPlobby() {
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 == null || (class_7462 = class_7462.method_7327()) == null) {
            return false;
        }
        class_746 scoreboard = class_7462;
        class_266 class_2662 = scoreboard.method_1189(class_8646.field_45157);
        if (class_2662 == null) {
            return false;
        }
        class_266 obj = class_2662;
        String string = obj.method_1114().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return StringsKt.contains((CharSequence)string, (CharSequence)"Plobby", (boolean)true);
    }

    private static final Unit handleTimedQuest$lambda$0(String $initialID, Function0 $action) {
        String currentID = WorldUtils.INSTANCE.getGameID();
        if (!Intrinsics.areEqual((Object)$initialID, (Object)currentID)) {
            return Unit.INSTANCE;
        }
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final void register$lambda$2(class_2561 message, boolean bl) {
        if (!Config.Questing.INSTANCE.getEnabled()) {
            return;
        }
        if (INSTANCE.checkIfPlobby()) {
            return;
        }
        Intrinsics.checkNotNull((Object)message);
        INSTANCE.handleRefreshTasksChat(message);
        INSTANCE.checkDesynced(message);
        if (MCCIState.INSTANCE.getGame() == Game.PARKOUR_WARRIOR_SURVIVOR) {
            PKWSurvivorHandlers.INSTANCE.handle(message);
        }
        if (MCCIState.INSTANCE.getGame() == Game.BATTLE_BOX) {
            BattleBoxHandlers.INSTANCE.handle(message);
        }
        if (MCCIState.INSTANCE.getGame() == Game.TGTTOS) {
            TGTTOSHandlers.INSTANCE.handle(message);
        }
        if (MCCIState.INSTANCE.getGame() == Game.SKY_BATTLE) {
            SkyBattleHandlers.INSTANCE.handle(message);
        }
        if (MCCIState.INSTANCE.getGame() == Game.ROCKET_SPLEEF_RUSH) {
            RSRHandlers.INSTANCE.handle(message);
        }
        if (MCCIState.INSTANCE.getGame() == Game.DYNABALL) {
            DynaballHandlers.INSTANCE.handle(message);
        }
    }
}

