/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.questing;

import cc.pe3epwithyou.trident.feature.questing.GameQuests;
import cc.pe3epwithyou.trident.feature.questing.Quest;
import cc.pe3epwithyou.trident.feature.questing.QuestCriteria;
import cc.pe3epwithyou.trident.feature.questing.QuestSubtype;
import cc.pe3epwithyou.trident.feature.questing.QuestType;
import cc.pe3epwithyou.trident.state.Game;
import cc.pe3epwithyou.trident.state.Rarity;
import cc.pe3epwithyou.trident.utils.ChatUtils;
import cc.pe3epwithyou.trident.utils.extensions.ItemStackExtensions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcc/pe3epwithyou/trident/feature/questing/QuestingParser;", "", "<init>", "()V", "Lnet/minecraft/class_1735;", "slot", "", "parseRemainingSlot", "(Lnet/minecraft/class_1735;)I", "", "Lcc/pe3epwithyou/trident/feature/questing/Quest;", "parseQuestSlot", "(Lnet/minecraft/class_1735;)Ljava/util/List;", "Lnet/minecraft/class_1799;", "item", "Lcc/pe3epwithyou/trident/feature/questing/QuestingParser$ParsedQuest;", "parseLore", "(Lnet/minecraft/class_1799;)Ljava/util/List;", "", "text", "Lcc/pe3epwithyou/trident/state/Game;", "getQuestGame", "(Ljava/lang/String;)Lcc/pe3epwithyou/trident/state/Game;", "FINISHED_MAPS", "Ljava/lang/String;", "ADD_SCROLL", "COMPLETED_QUEST", "ParsedQuest", "Trident"})
@SourceDebugExtension(value={"SMAP\nQuestingParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestingParser.kt\ncc/pe3epwithyou/trident/feature/questing/QuestingParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1869#2,2:154\n1869#2,2:156\n1878#2,3:158\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 QuestingParser.kt\ncc/pe3epwithyou/trident/feature/questing/QuestingParser\n*L\n18#1:154,2\n76#1:156,2\n101#1:158,3\n148#1:161,2\n*E\n"})
public final class QuestingParser {
    @NotNull
    public static final QuestingParser INSTANCE = new QuestingParser();
    @NotNull
    private static final String FINISHED_MAPS = "island_interface/generic/clock_used";
    @NotNull
    private static final String ADD_SCROLL = "island_interface/generic/add";
    @NotNull
    private static final String COMPLETED_QUEST = "island_interface/quest_log/quest_glow";

    private QuestingParser() {
    }

    public final int parseRemainingSlot(@NotNull class_1735 slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        class_1799 item = slot.method_7677();
        Intrinsics.checkNotNull((Object)item);
        Iterable $this$forEach$iv = ItemStackExtensions.INSTANCE.getLore(item);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2561 l = (class_2561)element$iv;
            boolean bl = false;
            Regex regex = new Regex("Remaining (Daily|Weekly) Quests: (\\d+)");
            String string = l.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            MatchResult match = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            if (match == null) continue;
            Object object = match.getGroups().get(2);
            int remaining = object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            return remaining;
        }
        return 0;
    }

    @Nullable
    public final List<Quest> parseQuestSlot(@NotNull class_1735 slot) {
        QuestSubtype questSubtype;
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        class_1799 item = slot.method_7677();
        class_2960 model = (class_2960)item.method_58694(class_9334.field_54199);
        if (model == null) {
            ChatUtils.INSTANCE.error("Failed to parse questing item in slot " + slot.field_7874 + ": Missing model");
            return null;
        }
        ChatUtils.INSTANCE.debugLog("Quest found: Slot " + slot.field_7874);
        ChatUtils.INSTANCE.debugLog("Model: " + model.method_12832());
        if (Intrinsics.areEqual((Object)model.method_12832(), (Object)FINISHED_MAPS) || Intrinsics.areEqual((Object)model.method_12832(), (Object)ADD_SCROLL) || Intrinsics.areEqual((Object)model.method_12832(), (Object)COMPLETED_QUEST)) {
            return null;
        }
        String string = model.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{"/"};
        Rarity rarity = switch ((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null))) {
            case "common" -> Rarity.COMMON;
            case "uncommon" -> Rarity.UNCOMMON;
            case "rare" -> Rarity.RARE;
            case "epic" -> Rarity.EPIC;
            case "legendary" -> Rarity.LEGENDARY;
            case "mythic" -> Rarity.MYTHIC;
            default -> Rarity.COMMON;
        };
        ChatUtils.INSTANCE.debugLog("Got rarity - " + rarity);
        QuestType type = null;
        type = QuestType.DEFAULT;
        for (QuestType t : QuestType.getEntries()) {
            String string2 = model.method_12832();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)t.getDirectoryPath(), (boolean)false, (int)2, null)) continue;
            type = t;
            break;
        }
        ChatUtils.INSTANCE.debugLog("Got type - " + (Object)((Object)type));
        String string3 = item.method_7964().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"Daily", (boolean)false, (int)2, null)) {
            questSubtype = QuestSubtype.DAILY;
        } else {
            String string4 = item.method_7964().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Weekly", (boolean)false, (int)2, null)) {
                questSubtype = QuestSubtype.WEEKLY;
            } else {
                String string5 = item.method_7964().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"Scroll", (boolean)false, (int)2, null)) {
                    questSubtype = QuestSubtype.SCROLL;
                } else {
                    return null;
                }
            }
        }
        QuestSubtype subtype = questSubtype;
        ChatUtils.INSTANCE.debugLog("Got subtype - " + subtype);
        List quests = new ArrayList();
        class_1799 class_17992 = slot.method_7677();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItem(...)");
        List<ParsedQuest> loreResult = this.parseLore(class_17992);
        ChatUtils.INSTANCE.debugLog("Got parsed quests - " + loreResult);
        if (loreResult.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = loreResult;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParsedQuest parsedQuest = (ParsedQuest)element$iv;
            boolean bl = false;
            quests.add(new Quest(parsedQuest.getGame(), type, subtype, rarity, parsedQuest.getCriteria(), ((Number)parsedQuest.getProgress().getFirst()).intValue(), ((Number)parsedQuest.getProgress().getSecond()).intValue()));
        }
        return quests;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ParsedQuest> parseLore(class_1799 item) {
        List<class_2561> lines = ItemStackExtensions.INSTANCE.getLore(item);
        List parsedQuests = new ArrayList();
        Game tempGame = null;
        QuestCriteria tempCriteria = null;
        Pair tempProgress = null;
        Object tempQuestString = null;
        tempQuestString = "";
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String[] stringArray;
            void l;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            class_2561 class_25612 = (class_2561)item$iv;
            int index = n;
            boolean bl = false;
            if (index <= 4 || parsedQuests.size() >= 3) continue;
            String string = l.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Progress: ", (boolean)false, (int)2, null)) {
                QuestCriteria questCriteria;
                Game game;
                String string2 = l.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String[] stringArray2 = new String[]{": "};
                String t = (String)StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
                String[] stringArray3 = new String[]{"/"};
                int current = Integer.parseInt(StringsKt.replace$default((String)((String)StringsKt.split$default((CharSequence)t, (String[])stringArray3, (boolean)false, (int)0, (int)6, null).get(0)), (String)",", (String)"", (boolean)false, (int)4, null));
                stringArray = new String[]{"/"};
                int total = Integer.parseInt(StringsKt.replace$default((String)((String)StringsKt.split$default((CharSequence)t, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)), (String)",", (String)"", (boolean)false, (int)4, null));
                tempProgress = new Pair((Object)current, (Object)total);
                ChatUtils.INSTANCE.debugLog("Got progress -> " + tempProgress);
                if (tempGame == null || tempCriteria == null) continue;
                Pair pair = tempProgress;
                ParsedQuest q = new ParsedQuest(game, questCriteria, (Pair<Integer, Integer>)pair);
                parsedQuests.add(q);
                tempGame = null;
                tempCriteria = null;
                ChatUtils.INSTANCE.debugLog("Cleared temp data");
                ChatUtils.INSTANCE.debugLog("--------------------");
                continue;
            }
            String string3 = l.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"%", (boolean)false, (int)2, null)) {
                ChatUtils.INSTANCE.debugLog("Hit the %, trying to detect game quest");
                if (INSTANCE.getQuestGame((String)tempQuestString) == null) continue;
                ChatUtils.INSTANCE.debugLog("Detected game quest -> " + tempGame.getTitle() + ": " + tempQuestString);
                List<QuestCriteria> criteriaList = GameQuests.valueOf(tempGame.name()).getList();
                ChatUtils.INSTANCE.debugLog("Criteria list -> " + criteriaList);
                for (QuestCriteria crit : criteriaList) {
                    stringArray = (String[])tempQuestString;
                    if (!crit.getRegexPattern().containsMatchIn((CharSequence)stringArray)) continue;
                    ChatUtils.INSTANCE.debugLog("Detected game criteria -> " + crit);
                    tempCriteria = crit;
                }
                tempQuestString = "";
                continue;
            }
            String string4 = l.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            String suffix = StringsKt.endsWith$default((String)string4, (String)" ", (boolean)false, (int)2, null) ? "" : " ";
            tempQuestString = tempQuestString + StringsKt.replace$default((String)(l.getString() + suffix), (String)",", (String)"", (boolean)false, (int)4, null);
            ChatUtils.INSTANCE.debugLog("New tempQuestString: " + tempQuestString);
        }
        return parsedQuests;
    }

    private final Game getQuestGame(String text) {
        Iterable $this$forEach$iv = (Iterable)Game.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Game g = (Game)((Object)element$iv);
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)text, (CharSequence)g.getTitle(), (boolean)false, (int)2, null)) continue;
            return g;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J:\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\u000eR#\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\u0010\u00a8\u0006\""}, d2={"Lcc/pe3epwithyou/trident/feature/questing/QuestingParser$ParsedQuest;", "", "Lcc/pe3epwithyou/trident/state/Game;", "game", "Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "criteria", "Lkotlin/Pair;", "", "progress", "<init>", "(Lcc/pe3epwithyou/trident/state/Game;Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;Lkotlin/Pair;)V", "component1", "()Lcc/pe3epwithyou/trident/state/Game;", "component2", "()Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "component3", "()Lkotlin/Pair;", "copy", "(Lcc/pe3epwithyou/trident/state/Game;Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;Lkotlin/Pair;)Lcc/pe3epwithyou/trident/feature/questing/QuestingParser$ParsedQuest;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcc/pe3epwithyou/trident/state/Game;", "getGame", "Lcc/pe3epwithyou/trident/feature/questing/QuestCriteria;", "getCriteria", "Lkotlin/Pair;", "getProgress", "Trident"})
    private static final class ParsedQuest {
        @NotNull
        private final Game game;
        @NotNull
        private final QuestCriteria criteria;
        @NotNull
        private final Pair<Integer, Integer> progress;

        public ParsedQuest(@NotNull Game game, @NotNull QuestCriteria criteria, @NotNull Pair<Integer, Integer> progress) {
            Intrinsics.checkNotNullParameter((Object)((Object)game), (String)"game");
            Intrinsics.checkNotNullParameter((Object)((Object)criteria), (String)"criteria");
            Intrinsics.checkNotNullParameter(progress, (String)"progress");
            this.game = game;
            this.criteria = criteria;
            this.progress = progress;
        }

        @NotNull
        public final Game getGame() {
            return this.game;
        }

        @NotNull
        public final QuestCriteria getCriteria() {
            return this.criteria;
        }

        @NotNull
        public final Pair<Integer, Integer> getProgress() {
            return this.progress;
        }

        @NotNull
        public final Game component1() {
            return this.game;
        }

        @NotNull
        public final QuestCriteria component2() {
            return this.criteria;
        }

        @NotNull
        public final Pair<Integer, Integer> component3() {
            return this.progress;
        }

        @NotNull
        public final ParsedQuest copy(@NotNull Game game, @NotNull QuestCriteria criteria, @NotNull Pair<Integer, Integer> progress) {
            Intrinsics.checkNotNullParameter((Object)((Object)game), (String)"game");
            Intrinsics.checkNotNullParameter((Object)((Object)criteria), (String)"criteria");
            Intrinsics.checkNotNullParameter(progress, (String)"progress");
            return new ParsedQuest(game, criteria, progress);
        }

        public static /* synthetic */ ParsedQuest copy$default(ParsedQuest parsedQuest, Game game, QuestCriteria questCriteria, Pair pair, int n, Object object) {
            if ((n & 1) != 0) {
                game = parsedQuest.game;
            }
            if ((n & 2) != 0) {
                questCriteria = parsedQuest.criteria;
            }
            if ((n & 4) != 0) {
                pair = parsedQuest.progress;
            }
            return parsedQuest.copy(game, questCriteria, pair);
        }

        @NotNull
        public String toString() {
            return "ParsedQuest(game=" + this.game + ", criteria=" + this.criteria + ", progress=" + this.progress + ")";
        }

        public int hashCode() {
            int result = this.game.hashCode();
            result = result * 31 + this.criteria.hashCode();
            result = result * 31 + this.progress.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedQuest)) {
                return false;
            }
            ParsedQuest parsedQuest = (ParsedQuest)other;
            if (this.game != parsedQuest.game) {
                return false;
            }
            if (this.criteria != parsedQuest.criteria) {
                return false;
            }
            return Intrinsics.areEqual(this.progress, parsedQuest.progress);
        }
    }
}

