/*
 * Decompiled with CFR 0.152.
 */
package cc.pe3epwithyou.trident.feature.questing.game;

import cc.pe3epwithyou.trident.feature.questing.IncrementContext;
import cc.pe3epwithyou.trident.feature.questing.QuestCriteria;
import cc.pe3epwithyou.trident.feature.questing.QuestStorage;
import cc.pe3epwithyou.trident.state.Game;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcc/pe3epwithyou/trident/feature/questing/game/PKWSurvivorHandlers;", "", "<init>", "()V", "Lnet/minecraft/class_2561;", "m", "", "handle", "(Lnet/minecraft/class_2561;)V", "Trident"})
public final class PKWSurvivorHandlers {
    @NotNull
    public static final PKWSurvivorHandlers INSTANCE = new PKWSurvivorHandlers();

    private PKWSurvivorHandlers() {
    }

    public final void handle(@NotNull class_2561 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Regex regex = new Regex("^\\[.] Leap (\\d) complete in: .+");
        String string = m.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        MatchResult leapFinished = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (leapFinished != null) {
            QuestCriteria questCriteria;
            MatchGroup matchGroup = leapFinished.getGroups().get(1);
            if (matchGroup == null) {
                return;
            }
            MatchGroup group = matchGroup;
            Integer n = StringsKt.toIntOrNull((String)group.getValue());
            if (n == null) {
                return;
            }
            int leap = n;
            switch (leap) {
                case 2: {
                    questCriteria = QuestCriteria.PW_SURVIVAL_LEAP_2_COMPLETION;
                    break;
                }
                case 4: {
                    questCriteria = QuestCriteria.PW_SURVIVAL_LEAP_4_COMPLETION;
                    break;
                }
                case 6: {
                    questCriteria = QuestCriteria.PW_SURVIVAL_LEAP_6_COMPLETION;
                    break;
                }
                default: {
                    return;
                }
            }
            QuestCriteria criteria = questCriteria;
            IncrementContext ctx = new IncrementContext(Game.PARKOUR_WARRIOR_SURVIVOR, criteria, 1, "leap_finished");
            QuestStorage.INSTANCE.applyIncrement(ctx, true);
        }
        Regex regex2 = new Regex("^\\[.] Leap \\d - \\d: .+ complete!");
        String string2 = m.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        MatchResult obstacleComplete = Regex.find$default((Regex)regex2, (CharSequence)string2, (int)0, (int)2, null);
        if (obstacleComplete != null) {
            IncrementContext ctx = new IncrementContext(Game.PARKOUR_WARRIOR_SURVIVOR, QuestCriteria.PW_SURVIVAL_OBSTACLES_COMPLETED, 1, "obstacle_complete");
            QuestStorage.INSTANCE.applyIncrement(ctx, true);
        }
        Regex regex3 = new Regex("^\\[.] .+ was eliminated\\. \\[.+]");
        String string3 = m.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        MatchResult playerOutlived = Regex.find$default((Regex)regex3, (CharSequence)string3, (int)0, (int)2, null);
        if (playerOutlived != null) {
            IncrementContext ctx = new IncrementContext(Game.PARKOUR_WARRIOR_SURVIVOR, QuestCriteria.PW_SURVIVAL_PLAYERS_ELIMINATED, 1, "player_outlived");
            QuestStorage.INSTANCE.applyIncrement(ctx, true);
        }
    }
}

